/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import java.util.Random;

class Wavetable {
    protected float[] waveform;

    public Wavetable(int size) {
        this.waveform = new float[size];
    }

    public Wavetable(float[] waveform) {
        this.waveform = waveform;
    }

    public void setWaveform(float[] waveform) {
        this.waveform = waveform;
    }

    public float get(int i) {
        return this.waveform[i];
    }

    public float[] getWaveform() {
        return this.waveform;
    }

    public void set(int i, float f) {
        this.waveform[i] = f;
    }

    public int size() {
        return this.waveform.length;
    }

    public void scale(float a) {
        int i = 0;
        while (i < this.waveform.length) {
            int n = i++;
            this.waveform[n] = this.waveform[n] * a;
        }
    }

    public void normalize() {
        float max = Float.MIN_VALUE;
        int i = 0;
        while (i < this.waveform.length) {
            if (Math.abs(this.waveform[i]) > max) {
                max = Math.abs(this.waveform[i]);
            }
            ++i;
        }
        this.scale(1.0f / max);
    }

    public void invert() {
        this.flip(0.0f);
    }

    public void flip(float in) {
        int i = 0;
        while (i < this.waveform.length) {
            this.waveform[i] = this.waveform[i] > in ? in - (this.waveform[i] - in) : in + (in - this.waveform[i]);
            ++i;
        }
    }

    public void addNoise(float sigma) {
        Random rgen = new Random();
        int i = 0;
        while (i < this.waveform.length) {
            int n = i++;
            this.waveform[n] = this.waveform[n] + (float)rgen.nextGaussian() * sigma;
        }
    }

    public void rectify() {
        int i = 0;
        while (i < this.waveform.length) {
            if (this.waveform[i] < 0.0f) {
                int n = i;
                this.waveform[n] = this.waveform[n] * -1.0f;
            }
            ++i;
        }
    }

    public void smooth(int windowLength) {
        if (windowLength < 1) {
            return;
        }
        float[] temp = (float[])this.waveform.clone();
        int i = windowLength;
        while (i < this.waveform.length) {
            float avg = 0.0f;
            int j = i - windowLength;
            while (j <= i) {
                avg += temp[j] / (float)windowLength;
                ++j;
            }
            this.waveform[i] = avg;
            ++i;
        }
    }
}

