/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.javascript;

import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import processing.app.Base;
import processing.app.Editor;
import processing.app.EditorToolbar;
import processing.mode.javascript.JavaScriptEditor;

public class JavaScriptToolbar
extends EditorToolbar {
    protected static final int NEW = 0;
    protected static final int OPEN = 1;
    protected static final int SAVE = 2;
    protected static final int EXPORT = 3;

    public static String getTitle(int index, boolean shift) {
        switch (index) {
            case 0: {
                return !shift ? "New" : "New Editor Window";
            }
            case 1: {
                return !shift ? "Open" : "Open in Another Window";
            }
            case 2: {
                return "Save";
            }
            case 3: {
                return "Export for Web";
            }
        }
        return null;
    }

    public JavaScriptToolbar(Editor editor, Base base) {
        super(editor, base);
    }

    public void init() {
        Image[][] images = this.loadImages();
        for (int i = 0; i < 4; ++i) {
            this.addButton(JavaScriptToolbar.getTitle(i, false), JavaScriptToolbar.getTitle(i, true), images[i], i == 0);
        }
    }

    public void handlePressed(MouseEvent e, int index) {
        boolean shift = e.isShiftDown();
        JavaScriptEditor jsEditor = (JavaScriptEditor)this.editor;
        switch (index) {
            case 1: {
                JPopupMenu popup = this.editor.getMode().getToolbarMenu().getPopupMenu();
                popup.show(this, e.getX(), e.getY());
                break;
            }
            case 0: {
                if (shift) {
                    this.base.handleNew();
                    break;
                }
                this.base.handleNewReplace();
                break;
            }
            case 2: {
                jsEditor.handleSaveRequest(false);
                break;
            }
            case 3: {
                jsEditor.handleExport();
            }
        }
    }
}

