/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.p3;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.AlphanumComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.common.MapRow;
import net.sf.mpxj.primavera.common.Table;
import net.sf.mpxj.primavera.p3.DatabaseReader;
import net.sf.mpxj.primavera.p3.P3WbsFormat;
import net.sf.mpxj.reader.ProjectReader;

public final class P3DatabaseReader
implements ProjectReader {
    private String m_projectName;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<String, Table> m_tables;
    private P3WbsFormat m_wbsFormat;
    private Map<String, Resource> m_resourceMap;
    private Map<String, Task> m_wbsMap;
    private Map<String, Task> m_activityMap;
    private static final Map<String, FieldType> PROJECT_FIELDS = new HashMap<String, FieldType>();
    private static final Map<String, FieldType> RESOURCE_FIELDS = new HashMap<String, FieldType>();
    private static final Map<String, FieldType> TASK_FIELDS = new HashMap<String, FieldType>();

    @Deprecated
    public static final ProjectFile setPrefixAndRead(File file) throws MPXJException {
        return P3DatabaseReader.setProjectNameAndRead(file);
    }

    public static final ProjectFile setProjectNameAndRead(File file) throws MPXJException {
        List<String> list = P3DatabaseReader.listProjectNames(file);
        if (!list.isEmpty()) {
            P3DatabaseReader p3DatabaseReader = new P3DatabaseReader();
            p3DatabaseReader.setProjectName(list.get(0));
            return p3DatabaseReader.read(file);
        }
        return null;
    }

    public static final List<String> listProjectNames(String string) {
        return P3DatabaseReader.listProjectNames(new File(string));
    }

    public static final List<String> listProjectNames(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith("STR.P3");
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string = file2.getName();
                String string2 = string.substring(0, string.length() - 6);
                arrayList.add(string2);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPrefix(String string) {
        this.m_projectName = string;
    }

    public void setProjectName(String string) {
        this.m_projectName = string;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        if (!file.isDirectory()) {
            throw new MPXJException("Directory expected");
        }
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoResourceID(true);
            projectConfig.setAutoResourceUniqueID(true);
            projectConfig.setAutoTaskID(true);
            projectConfig.setAutoTaskUniqueID(true);
            projectConfig.setAutoOutlineLevel(true);
            projectConfig.setAutoOutlineNumber(true);
            projectConfig.setAutoWBS(false);
            this.m_projectFile.getCustomFields().getCustomField(TaskField.TEXT1).setAlias("Code");
            this.m_projectFile.getProjectProperties().setFileApplication("P3");
            this.m_projectFile.getProjectProperties().setFileType("BTRIEVE");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            this.m_tables = new DatabaseReader().process(file, this.m_projectName);
            this.m_resourceMap = new HashMap<String, Resource>();
            this.m_wbsMap = new HashMap<String, Task>();
            this.m_activityMap = new HashMap<String, Task>();
            this.readProjectHeader();
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Failed to parse file", iOException);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_projectListeners = null;
            this.m_tables = null;
            this.m_resourceMap = null;
            this.m_wbsFormat = null;
            this.m_wbsMap = null;
            this.m_activityMap = null;
        }
    }

    private void readProjectHeader() {
        Table table = this.m_tables.get("DIR");
        MapRow mapRow = table.find("");
        if (mapRow != null) {
            this.setFields(PROJECT_FIELDS, mapRow, this.m_projectFile.getProjectProperties());
            this.m_wbsFormat = new P3WbsFormat(mapRow);
        }
    }

    private void readCalendars() {
    }

    private void readResources() {
        for (MapRow mapRow : this.m_tables.get("RLB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, mapRow, resource);
            this.m_resourceMap.put(resource.getCode(), resource);
        }
    }

    private void readTasks() {
        this.readWBS();
        this.readActivities();
        this.updateDates();
    }

    private void readWBS() {
        Object object;
        Object object2;
        Object object32;
        HashMap hashMap = new HashMap();
        for (Object object32 : this.m_tables.get("STR")) {
            object2 = ((MapRow)object32).getInteger("LEVEL_NUMBER");
            object = (ArrayList<Object>)hashMap.get(object2);
            if (object == null) {
                object = new ArrayList<Object>();
                hashMap.put(object2, object);
            }
            object.add(object32);
        }
        int n = 1;
        while ((object32 = (List)hashMap.get(n++)) != null) {
            String string;
            Object object4;
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (MapRow)object2.next();
                this.m_wbsFormat.parseRawValue(((MapRow)object).getString("CODE_VALUE"));
                object4 = this.m_wbsFormat.getFormattedParentValue();
                string = this.m_wbsFormat.getFormattedValue();
                ((MapRow)object).setObject("WBS", string);
                ((MapRow)object).setObject("PARENT_WBS", object4);
            }
            object2 = new AlphanumComparator();
            Collections.sort(object32, new Comparator<MapRow>((AlphanumComparator)object2){
                final /* synthetic */ AlphanumComparator val$comparator;
                {
                    this.val$comparator = alphanumComparator;
                }

                @Override
                public int compare(MapRow mapRow, MapRow mapRow2) {
                    return this.val$comparator.compare(mapRow.getString("WBS"), mapRow2.getString("WBS"));
                }
            });
            object = object32.iterator();
            while (object.hasNext()) {
                object4 = (MapRow)object.next();
                string = ((MapRow)object4).getString("WBS");
                if (string == null || string.isEmpty()) continue;
                ChildTaskContainer childTaskContainer = this.m_wbsMap.get(((MapRow)object4).getString("PARENT_WBS"));
                if (childTaskContainer == null) {
                    childTaskContainer = this.m_projectFile;
                }
                Task task = childTaskContainer.addTask();
                String string2 = ((MapRow)object4).getString("CODE_TITLE");
                if (string2 == null || string2.isEmpty()) {
                    string2 = string;
                }
                task.setName(string2);
                task.setWBS(string);
                this.m_wbsMap.put(string, task);
            }
        }
    }

    private void readActivities() {
        Object object;
        Object object2;
        Iterator iterator2;
        Object object32;
        HashMap hashMap = new HashMap();
        for (Object object32 : this.m_tables.get("WBS")) {
            iterator2 = ((MapRow)object32).getString("ACTIVITY_ID");
            this.m_wbsFormat.parseRawValue(((MapRow)object32).getString("CODE_VALUE"));
            object2 = this.m_wbsFormat.getFormattedValue();
            object = this.m_wbsMap.get(object2);
            if (object == null) continue;
            hashMap.put(iterator2, (ChildTaskContainer)object);
        }
        ArrayList arrayList = new ArrayList();
        for (Iterator iterator2 : this.m_tables.get("ACT")) {
            arrayList.add(iterator2);
        }
        object32 = new AlphanumComparator();
        Collections.sort(arrayList, new Comparator<MapRow>((AlphanumComparator)object32){
            final /* synthetic */ AlphanumComparator val$comparator;
            {
                this.val$comparator = alphanumComparator;
            }

            @Override
            public int compare(MapRow mapRow, MapRow mapRow2) {
                return this.val$comparator.compare(mapRow.getString("ACTIVITY_ID"), mapRow2.getString("ACTIVITY_ID"));
            }
        });
        iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Date date;
            int n;
            object2 = (MapRow)iterator2.next();
            object = ((MapRow)object2).getString("ACTIVITY_ID");
            ChildTaskContainer childTaskContainer = (ChildTaskContainer)hashMap.get(object);
            if (childTaskContainer == null) {
                childTaskContainer = this.m_projectFile;
            }
            Task task = childTaskContainer.addTask();
            this.setFields(TASK_FIELDS, (MapRow)object2, task);
            task.setStart(task.getEarlyStart());
            task.setFinish(task.getEarlyFinish());
            task.setMilestone(task.getDuration().getDuration() == 0.0);
            if (childTaskContainer instanceof Task) {
                task.setWBS(((Task)childTaskContainer).getWBS());
            }
            if ((n = ((MapRow)object2).getInteger("ACTUAL_START_OR_CONSTRAINT_FLAG").intValue()) != 0) {
                date = ((MapRow)object2).getDate("AS_OR_ED_CONSTRAINT");
                switch (n) {
                    case 1: {
                        task.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 3: {
                        task.setConstraintType(ConstraintType.FINISH_NO_EARLIER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 99: {
                        task.setActualStart(date);
                    }
                }
            }
            if ((n = ((MapRow)object2).getInteger("ACTUAL_FINISH_OR_CONSTRAINT_FLAG").intValue()) != 0) {
                date = ((MapRow)object2).getDate("AF_OR_LD_CONSTRAINT");
                switch (n) {
                    case 2: {
                        task.setConstraintType(ConstraintType.START_NO_LATER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 4: {
                        task.setConstraintType(ConstraintType.FINISH_NO_LATER_THAN);
                        task.setConstraintDate(date);
                        break;
                    }
                    case 99: {
                        task.setActualFinish(date);
                    }
                }
            }
            this.m_activityMap.put((String)object, task);
        }
    }

    private void readRelationships() {
        for (MapRow mapRow : this.m_tables.get("REL")) {
            Task task = this.m_activityMap.get(mapRow.getString("PREDECESSOR_ACTIVITY_ID"));
            Task task2 = this.m_activityMap.get(mapRow.getString("SUCCESSOR_ACTIVITY_ID"));
            if (task == null || task2 == null) continue;
            Duration duration = mapRow.getDuration("LAG_VALUE");
            RelationType relationType = mapRow.getRelationType("LAG_TYPE");
            task2.addPredecessor(task, relationType, duration);
        }
    }

    private void readResourceAssignments() {
        for (MapRow mapRow : this.m_tables.get("RES")) {
            Task task = this.m_activityMap.get(mapRow.getString("ACTIVITY_ID"));
            Resource resource = this.m_resourceMap.get(mapRow.getString("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            task.addResourceAssignment(resource);
        }
    }

    private void updateDates() {
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.updateDates(task);
        }
    }

    private void updateDates(Task task) {
        if (task.getSummary()) {
            int n = 0;
            Date date = task.getStart();
            Date date2 = task.getFinish();
            Date date3 = task.getActualStart();
            Date date4 = task.getActualFinish();
            Date date5 = task.getEarlyStart();
            Date date6 = task.getEarlyFinish();
            Date date7 = task.getLateStart();
            Date date8 = task.getLateFinish();
            for (Task task2 : task.getChildTasks()) {
                this.updateDates(task2);
                date = DateHelper.min(date, task2.getStart());
                date2 = DateHelper.max(date2, task2.getFinish());
                date3 = DateHelper.min(date3, task2.getActualStart());
                date4 = DateHelper.max(date4, task2.getActualFinish());
                date5 = DateHelper.min(date5, task2.getEarlyStart());
                date6 = DateHelper.max(date6, task2.getEarlyFinish());
                date7 = DateHelper.min(date7, task2.getLateStart());
                date8 = DateHelper.max(date8, task2.getLateFinish());
                if (task2.getActualFinish() == null) continue;
                ++n;
            }
            task.setStart(date);
            task.setFinish(date2);
            task.setActualStart(date3);
            task.setEarlyStart(date5);
            task.setEarlyFinish(date6);
            task.setLateStart(date7);
            task.setLateFinish(date8);
            if (n == task.getChildTasks().size()) {
                task.setActualFinish(date4);
            }
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow mapRow, FieldContainer fieldContainer) {
        if (mapRow != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                fieldContainer.set(entry.getValue(), mapRow.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType) {
        P3DatabaseReader.defineField(map, string, fieldType, null);
    }

    private static void defineField(Map<String, FieldType> map, String string, FieldType fieldType, String string2) {
        map.put(string, fieldType);
    }

    static {
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_START_DATE", ProjectField.START_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_FINISH_DATE", ProjectField.FINISH_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "CURRENT_DATA_DATE", ProjectField.STATUS_DATE);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "COMPANY_TITLE", ProjectField.COMPANY);
        P3DatabaseReader.defineField(PROJECT_FIELDS, "PROJECT_TITLE", ProjectField.NAME);
        P3DatabaseReader.defineField(RESOURCE_FIELDS, "RES_TITLE", ResourceField.NAME);
        P3DatabaseReader.defineField(RESOURCE_FIELDS, "RES_ID", ResourceField.CODE);
        P3DatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_TITLE", TaskField.NAME);
        P3DatabaseReader.defineField(TASK_FIELDS, "ACTIVITY_ID", TaskField.TEXT1);
        P3DatabaseReader.defineField(TASK_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        P3DatabaseReader.defineField(TASK_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
        P3DatabaseReader.defineField(TASK_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        P3DatabaseReader.defineField(TASK_FIELDS, "EARLY_START", TaskField.EARLY_START);
        P3DatabaseReader.defineField(TASK_FIELDS, "LATE_START", TaskField.LATE_START);
        P3DatabaseReader.defineField(TASK_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        P3DatabaseReader.defineField(TASK_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        P3DatabaseReader.defineField(TASK_FIELDS, "FREE_FLOAT", TaskField.FREE_SLACK);
        P3DatabaseReader.defineField(TASK_FIELDS, "TOTAL_FLOAT", TaskField.TOTAL_SLACK);
    }
}

