'''OpenGL extension VERSION.GL_4_4

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_4_4 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_4_4.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_4_4 import *
from OpenGL.raw.GL.VERSION.GL_4_4 import _EXTENSION_NAME

def glInitGl44VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glBufferStorage.data size not checked against size
glBufferStorage=wrapper.wrapper(glBufferStorage).setInputArraySize(
    'data', None
)
# INPUT glClearTexImage.data size not checked against 'format,type'
glClearTexImage=wrapper.wrapper(glClearTexImage).setInputArraySize(
    'data', None
)
# INPUT glClearTexSubImage.data size not checked against 'format,type'
glClearTexSubImage=wrapper.wrapper(glClearTexSubImage).setInputArraySize(
    'data', None
)
# INPUT glBindBuffersBase.buffers size not checked against count
glBindBuffersBase=wrapper.wrapper(glBindBuffersBase).setInputArraySize(
    'buffers', None
)
# INPUT glBindBuffersRange.buffers size not checked against count
# INPUT glBindBuffersRange.offsets size not checked against count
# INPUT glBindBuffersRange.sizes size not checked against count
glBindBuffersRange=wrapper.wrapper(glBindBuffersRange).setInputArraySize(
    'buffers', None
).setInputArraySize(
    'offsets', None
).setInputArraySize(
    'sizes', None
)
# INPUT glBindTextures.textures size not checked against count
glBindTextures=wrapper.wrapper(glBindTextures).setInputArraySize(
    'textures', None
)
# INPUT glBindSamplers.samplers size not checked against count
glBindSamplers=wrapper.wrapper(glBindSamplers).setInputArraySize(
    'samplers', None
)
# INPUT glBindImageTextures.textures size not checked against count
glBindImageTextures=wrapper.wrapper(glBindImageTextures).setInputArraySize(
    'textures', None
)
# INPUT glBindVertexBuffers.buffers size not checked against count
# INPUT glBindVertexBuffers.offsets size not checked against count
# INPUT glBindVertexBuffers.strides size not checked against count
glBindVertexBuffers=wrapper.wrapper(glBindVertexBuffers).setInputArraySize(
    'buffers', None
).setInputArraySize(
    'offsets', None
).setInputArraySize(
    'strides', None
)
### END AUTOGENERATED SECTION
