/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.FileConfigurationException;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerAddModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerExplicitValueModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerInteractiveModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerShiftLeftModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerShiftRightModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerSubtractModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerXorModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Scanner;

public class BigIntegerModificationFactory {
    private static final int MODIFICATION_COUNT = 7;
    private static final int MAX_MODIFICATION_VALUE = 320000;
    private static final int MAX_MODIFICATION_SHIFT_VALUE = 50;
    private static List<VariableModification<BigInteger>> modificationsFromFile;
    private static BigIntegerInteractiveModification.InteractiveBigIntegerModification standardInteractiveModification;

    public static BigIntegerAddModification add(String summand) {
        return BigIntegerModificationFactory.add(new BigInteger(summand));
    }

    public static BigIntegerAddModification add(BigInteger summand) {
        return new BigIntegerAddModification(summand);
    }

    public static BigIntegerShiftLeftModification shiftLeft(String shift) {
        return BigIntegerModificationFactory.shiftLeft(new Integer(shift));
    }

    public static BigIntegerShiftLeftModification shiftLeft(Integer shift) {
        return new BigIntegerShiftLeftModification(shift);
    }

    public static BigIntegerShiftRightModification shiftRight(String shift) {
        return BigIntegerModificationFactory.shiftRight(new Integer(shift));
    }

    public static BigIntegerShiftRightModification shiftRight(Integer shift) {
        return new BigIntegerShiftRightModification(shift);
    }

    public static VariableModification<BigInteger> sub(String subtrahend) {
        return BigIntegerModificationFactory.sub(new BigInteger(subtrahend));
    }

    public static VariableModification<BigInteger> sub(BigInteger subtrahend) {
        return new BigIntegerSubtractModification(subtrahend);
    }

    public static VariableModification<BigInteger> xor(String xor) {
        return BigIntegerModificationFactory.xor(new BigInteger(xor));
    }

    public static VariableModification<BigInteger> xor(BigInteger xor) {
        return new BigIntegerXorModification(xor);
    }

    public static VariableModification<BigInteger> explicitValue(String value) {
        return BigIntegerModificationFactory.explicitValue(new BigInteger(value));
    }

    public static VariableModification<BigInteger> explicitValue(BigInteger value) {
        return new BigIntegerExplicitValueModification(value);
    }

    public static VariableModification<BigInteger> explicitValueFromFile(int value) {
        List<VariableModification<BigInteger>> modifications = BigIntegerModificationFactory.modificationsFromFile();
        int pos = value % modifications.size();
        return modifications.get(pos);
    }

    public static void setStandardInteractiveModification(BigIntegerInteractiveModification.InteractiveBigIntegerModification modification) {
        standardInteractiveModification = modification;
    }

    protected static BigIntegerInteractiveModification.InteractiveBigIntegerModification getStandardInteractiveModification() {
        return standardInteractiveModification;
    }

    public static VariableModification<BigInteger> interactive() {
        return new BigIntegerInteractiveModification();
    }

    public static synchronized List<VariableModification<BigInteger>> modificationsFromFile() {
        try {
            if (modificationsFromFile == null) {
                String line;
                modificationsFromFile = new LinkedList<VariableModification<BigInteger>>();
                ClassLoader classLoader = ByteArrayModificationFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream("de/rub/nds/modifiablevariable/explicit/integer.vec");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    String value = line.trim().split(" ")[0];
                    if (value.equals("")) continue;
                    modificationsFromFile.add(BigIntegerModificationFactory.explicitValue(value));
                }
            }
            return modificationsFromFile;
        }
        catch (IOException ex) {
            throw new FileConfigurationException("Modifiable variable file name could not have been found.", ex);
        }
    }

    public static VariableModification<BigInteger> createRandomModification() {
        Random random = RandomHelper.getRandom();
        int r = random.nextInt(7);
        BigInteger modification = BigInteger.valueOf(random.nextInt(320000));
        int shiftModification = random.nextInt(50);
        VariableModification vm = null;
        switch (r) {
            case 0: {
                vm = new BigIntegerAddModification(modification);
                return vm;
            }
            case 1: {
                vm = new BigIntegerSubtractModification(modification);
                return vm;
            }
            case 2: {
                vm = new BigIntegerXorModification(modification);
                return vm;
            }
            case 3: {
                vm = new BigIntegerExplicitValueModification(modification);
                return vm;
            }
            case 4: {
                vm = new BigIntegerShiftLeftModification(shiftModification);
                return vm;
            }
            case 5: {
                vm = new BigIntegerShiftRightModification(shiftModification);
                return vm;
            }
            case 6: {
                vm = BigIntegerModificationFactory.explicitValueFromFile(320000);
                return vm;
            }
        }
        return vm;
    }

    private BigIntegerModificationFactory() {
    }

    static {
        standardInteractiveModification = new BigIntegerInteractiveModification.InteractiveBigIntegerModification(){
            private BigInteger value;

            @Override
            public BigInteger modify(BigInteger oldVal) {
                if (this.value == null) {
                    System.out.println("Enter new value for BigInt: ");
                    this.value = new Scanner(System.in).nextBigInteger();
                }
                return this.value;
            }
        };
    }
}

