/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp.proxy;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.ProxyableTransportHandler;
import de.rub.nds.tlsattacker.transport.TimeableTransportHandler;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import de.rub.nds.tlsattacker.transport.exception.InvalidTransportHandlerStateException;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class TimingProxyClientTcpTransportHandler
extends TransportHandler
implements ProxyableTransportHandler,
TimeableTransportHandler {
    protected Socket dataSocket;
    protected Socket controlSocket;
    protected String hostname;
    protected int port;
    protected String proxyDataHostName = "127.0.0.1";
    protected int proxyDataPort = 4444;
    protected String proxyControlHostName = "127.0.0.1";
    protected int proxyControlPort = 5555;
    protected Long measurement = null;

    @Override
    public byte[] fetchData() throws IOException {
        byte[] data = super.fetchData();
        byte[] controlData = new byte[8];
        if (data.length > 0) {
            int bytesRead = this.controlSocket.getInputStream().read(controlData);
            if (bytesRead != 8) {
                throw new IOException("Should return 64 bit unsigned int");
            }
            this.measurement = ByteBuffer.wrap(controlData).getLong();
        }
        return data;
    }

    public TimingProxyClientTcpTransportHandler(Connection connection) {
        super(connection.getTimeout().intValue(), ConnectionEndType.CLIENT);
        this.hostname = connection.getHostname();
        this.port = connection.getPort();
        this.proxyDataHostName = connection.getProxyDataHostname();
        this.proxyDataPort = connection.getProxyDataPort();
        this.proxyControlHostName = connection.getProxyControlHostname();
        this.proxyControlPort = connection.getProxyControlPort();
        this.setIsInStreamTerminating(false);
    }

    public TimingProxyClientTcpTransportHandler(long timeout, String hostname, int port) {
        super(timeout, ConnectionEndType.CLIENT);
        this.hostname = hostname;
        this.port = port;
        this.setIsInStreamTerminating(false);
    }

    @Override
    public void setProxy(String dataChannelHost, int dataChanelPort, String controlChannelHost, int controlChanelPort) {
        this.proxyDataHostName = dataChannelHost;
        this.proxyDataPort = dataChanelPort;
        this.proxyControlHostName = controlChannelHost;
        this.proxyControlPort = controlChanelPort;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.dataSocket == null) {
            throw new IOException("Transporthandler is not initalized!");
        }
        this.dataSocket.close();
        if (this.controlSocket == null) {
            throw new IOException("Transporthandler is not initalized!");
        }
        this.controlSocket.close();
    }

    @Override
    public void initialize() throws IOException {
        this.controlSocket = new Socket();
        this.controlSocket.connect(new InetSocketAddress(this.proxyControlHostName, this.proxyControlPort), (int)this.timeout);
        this.dataSocket = new Socket();
        this.dataSocket.connect(new InetSocketAddress(this.proxyDataHostName, this.proxyDataPort), (int)this.timeout);
        if (!this.dataSocket.isConnected()) {
            throw new IOException("Could not connect to " + this.proxyDataHostName + ":" + this.proxyDataPort);
        }
        this.controlSocket.getOutputStream().write((this.hostname + "\n").getBytes());
        this.controlSocket.getOutputStream().write((Integer.toString(this.port) + "\n").getBytes());
        this.controlSocket.getOutputStream().flush();
        this.setStreams(new PushbackInputStream(this.dataSocket.getInputStream()), this.dataSocket.getOutputStream());
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.dataSocket.isClosed() || this.dataSocket.isInputShutdown() || this.controlSocket.isClosed() || this.controlSocket.isInputShutdown();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }

    public SocketState getSocketState() throws InvalidTransportHandlerStateException {
        try {
            if (this.dataSocket.getInputStream().available() > 0) {
                return SocketState.DATA_AVAILABLE;
            }
            this.dataSocket.setSoTimeout(1);
            int read = this.dataSocket.getInputStream().read();
            if (read == -1) {
                return SocketState.CLOSED;
            }
            throw new InvalidTransportHandlerStateException("Received Data during SocketState check");
        }
        catch (SocketTimeoutException ex) {
            return SocketState.TIMEOUT;
        }
        catch (SocketException ex) {
            return SocketState.SOCKET_EXCEPTION;
        }
        catch (IOException ex) {
            return SocketState.IO_EXCEPTION;
        }
    }

    @Override
    public Long getLastMeasurement() {
        return this.measurement;
    }
}

