/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;

public class ServerName {
    protected short nameType;
    protected Object name;

    public ServerName(short nameType, Object name) {
        if (!ServerName.isCorrectType(nameType, name)) {
            throw new IllegalArgumentException("'name' is not an instance of the correct type");
        }
        this.nameType = nameType;
        this.name = name;
    }

    public short getNameType() {
        return this.nameType;
    }

    public Object getName() {
        return this.name;
    }

    public String getHostName() {
        if (!ServerName.isCorrectType((short)0, this.name)) {
            throw new IllegalStateException("'name' is not a HostName string");
        }
        return (String)this.name;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.nameType, output);
        switch (this.nameType) {
            case 0: {
                byte[] asciiEncoding = ((String)this.name).getBytes("ASCII");
                if (asciiEncoding.length < 1) {
                    throw new TlsFatalAlert(80);
                }
                TlsUtils.writeOpaque16(asciiEncoding, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static ServerName parse(InputStream input) throws IOException {
        String name;
        short name_type = TlsUtils.readUint8(input);
        switch (name_type) {
            case 0: {
                byte[] asciiEncoding = TlsUtils.readOpaque16(input);
                if (asciiEncoding.length < 1) {
                    throw new TlsFatalAlert(50);
                }
                name = new String(asciiEncoding, "ASCII");
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new ServerName(name_type, name);
    }

    protected static boolean isCorrectType(short nameType, Object name) {
        switch (nameType) {
            case 0: {
                return name instanceof String;
            }
        }
        throw new IllegalArgumentException("'nameType' is an unsupported NameType");
    }
}

