/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.mac;

import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JavaMac
implements WrappedMac {
    private final Mac mac;

    public JavaMac(String javaName, byte[] key) {
        try {
            this.mac = Mac.getInstance(javaName);
            this.mac.init(new SecretKeySpec(key, this.mac.getAlgorithm()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("Mac not supported: " + javaName, ex);
        }
    }

    @Override
    public byte[] calculateMac(byte[] data) {
        this.mac.update(data);
        return this.mac.doFinal();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }
}

