/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ClientMasterKeyHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.RSAClientComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlElement;

public class SSL2ClientMasterKeyMessage
extends SSL2HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray cipherKind;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger clearKeyLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger encryptedKeyLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger keyArgLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray clearKeyData;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray encryptedKeyData;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray keyArgData;
    @HoldsModifiableVariable
    @XmlElement
    private RSAClientComputations computations;

    public SSL2ClientMasterKeyMessage() {
        super(HandshakeMessageType.SSL2_CLIENT_MASTER_KEY);
    }

    public SSL2ClientMasterKeyMessage(Config config) {
        this();
    }

    @Override
    public String toCompactString() {
        return "SSL2 ClientMasterKey Message";
    }

    @Override
    public SSL2ClientMasterKeyHandler getHandler(TlsContext context) {
        return new SSL2ClientMasterKeyHandler(context);
    }

    public ModifiableByteArray getCipherKind() {
        return this.cipherKind;
    }

    public void setCipherKind(ModifiableByteArray cipherKind) {
        this.cipherKind = cipherKind;
    }

    public void setCipherKind(byte[] cipherKind) {
        this.cipherKind = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherKind, (byte[])cipherKind);
    }

    public ModifiableInteger getClearKeyLength() {
        return this.clearKeyLength;
    }

    public void setClearKeyLength(int clearKeyLength) {
        this.clearKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.clearKeyLength, (Integer)clearKeyLength);
    }

    public void setClearKeyLength(ModifiableInteger clearKeyLength) {
        this.clearKeyLength = clearKeyLength;
    }

    public ModifiableInteger getEncryptedKeyLength() {
        return this.encryptedKeyLength;
    }

    public void setEncryptedKeyLength(int encryptedKeyLength) {
        this.encryptedKeyLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.encryptedKeyLength, (Integer)encryptedKeyLength);
    }

    public void setEncryptedKeyLength(ModifiableInteger encryptedKeyLength) {
        this.encryptedKeyLength = encryptedKeyLength;
    }

    public ModifiableInteger getKeyArgLength() {
        return this.keyArgLength;
    }

    public void setKeyArgLength(int keyArgLength) {
        this.keyArgLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.keyArgLength, (Integer)keyArgLength);
    }

    public void setKeyArgLength(ModifiableInteger keyArgLength) {
        this.keyArgLength = keyArgLength;
    }

    public ModifiableByteArray getClearKeyData() {
        return this.clearKeyData;
    }

    public void setClearKeyData(ModifiableByteArray clearKeyData) {
        this.clearKeyData = clearKeyData;
    }

    public void setClearKeyData(byte[] clearKeyData) {
        this.clearKeyData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.clearKeyData, (byte[])clearKeyData);
    }

    public ModifiableByteArray getEncryptedKeyData() {
        return this.encryptedKeyData;
    }

    public void setEncryptedKeyData(ModifiableByteArray encryptedKeyData) {
        this.encryptedKeyData = encryptedKeyData;
    }

    public void setEncryptedKeyData(byte[] encryptedKeyData) {
        this.encryptedKeyData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encryptedKeyData, (byte[])encryptedKeyData);
    }

    public ModifiableByteArray getKeyArgData() {
        return this.keyArgData;
    }

    public void setKeyArgData(ModifiableByteArray keyArgData) {
        this.keyArgData = keyArgData;
    }

    public void setKeyArgData(byte[] keyArgData) {
        this.keyArgData = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.keyArgData, (byte[])keyArgData);
    }

    public void prepareComputations() {
        if (this.computations == null) {
            this.computations = new RSAClientComputations();
        }
    }

    public RSAClientComputations getComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.getCipherKind() != null && this.getCipherKind().getValue() != null) {
            sb.append("\n Cipher Kind: ").append(this.getCipherKind().getValue());
        }
        if (this.getClearKeyData() != null && this.getClearKeyData().getValue() != null) {
            sb.append("\n Clear Key Data: ").append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getClearKeyData().getValue())));
        }
        if (this.getEncryptedKeyData() != null && this.getEncryptedKeyData().getValue() != null) {
            sb.append("\n Encrypted Key Data: ").append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getEncryptedKeyData().getValue())));
        }
        if (this.getKeyArgData() != null && this.getKeyArgData().getValue() != null) {
            sb.append("\n Key Arg Data: ").append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getKeyArgData().getValue())));
        }
        return sb.toString();
    }
}

