/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateVerifyParser
extends HandshakeMessageParser<CertificateVerifyMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateVerifyParser(int pointer, byte[] array, ProtocolVersion version, Config config) {
        super(pointer, array, HandshakeMessageType.CERTIFICATE_VERIFY, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(CertificateVerifyMessage msg) {
        LOGGER.debug("Parsing CertificateVerifyMessage");
        if (this.getVersion() == ProtocolVersion.TLS12 || this.getVersion() == ProtocolVersion.DTLS12 || this.getVersion().isTLS13()) {
            this.parseSignatureHashAlgorithm(msg);
        }
        this.parseSignatureLength(msg);
        this.parseSignature(msg);
    }

    @Override
    protected CertificateVerifyMessage createHandshakeMessage() {
        return new CertificateVerifyMessage();
    }

    private void parseSignatureHashAlgorithm(CertificateVerifyMessage msg) {
        msg.setSignatureHashAlgorithm(this.parseByteArrayField(2));
        LOGGER.debug("SignatureHashAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureHashAlgorithm().getValue())));
    }

    private void parseSignatureLength(CertificateVerifyMessage msg) {
        msg.setSignatureLength(this.parseIntField(2));
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }

    private void parseSignature(CertificateVerifyMessage msg) {
        msg.setSignature(this.parseByteArrayField((Integer)msg.getSignatureLength().getValue()));
        LOGGER.debug("Signatur: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }
}

