/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloParser
extends SSL2HandshakeMessageParser<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ServerHelloParser(byte[] message, int pointer, ProtocolVersion selectedProtocolVersion, Config config) {
        super(pointer, message, selectedProtocolVersion, config);
    }

    @Override
    protected SSL2ServerHelloMessage parseMessageContent() {
        LOGGER.debug("Parsing SSL2ServerHello");
        SSL2ServerHelloMessage message = new SSL2ServerHelloMessage();
        this.parseMessageLength(message);
        this.parseType(message);
        this.parseSessionIdHit(message);
        this.parseCertificateType(message);
        this.parseProtocolVersion(message);
        this.parseCertificateLength(message);
        this.parseCipherSuitesLength(message);
        this.parseSessionIDLength(message);
        this.parseCertificate(message);
        this.parseCipherSuites(message);
        this.parseSessionID(message);
        return message;
    }

    private void parseSessionIdHit(SSL2ServerHelloMessage message) {
        message.setSessionIdHit(this.parseByteField(1));
        LOGGER.debug("SessionIdHit: " + message.getSessionIdHit().getValue());
    }

    private void parseCertificateType(SSL2ServerHelloMessage message) {
        message.setCertificateType(this.parseByteField(1));
        LOGGER.debug("CertificateType: " + message.getCertificateType().getValue());
    }

    private void parseProtocolVersion(SSL2ServerHelloMessage message) {
        message.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
    }

    private void parseCertificateLength(SSL2ServerHelloMessage message) {
        message.setCertificateLength(this.parseIntField(2));
        LOGGER.debug("CertificateLength: " + message.getCertificateLength().getValue());
    }

    private void parseCipherSuitesLength(SSL2ServerHelloMessage message) {
        message.setCipherSuitesLength(this.parseIntField(2));
        LOGGER.debug("CipherSuitesLength: " + message.getCipherSuitesLength().getValue());
    }

    private void parseSessionIDLength(SSL2ServerHelloMessage message) {
        message.setSessionIDLength(this.parseIntField(2));
        LOGGER.debug("SessionIDLength: " + message.getSessionIdLength().getValue());
    }

    private void parseCertificate(SSL2ServerHelloMessage message) {
        message.setCertificate(this.parseByteArrayField((Integer)message.getCertificateLength().getValue()));
        LOGGER.debug("Certificate: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getCertificate().getValue())));
    }

    private void parseCipherSuites(SSL2ServerHelloMessage message) {
        message.setCipherSuites(this.parseByteArrayField((Integer)message.getCipherSuitesLength().getValue()));
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getCipherSuites().getValue())));
    }

    private void parseSessionID(SSL2ServerHelloMessage message) {
        message.setSessionID(this.parseByteArrayField((Integer)message.getSessionIdLength().getValue()));
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSessionId().getValue())));
    }
}

