/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedRandomExtensionSerializer
extends ExtensionSerializer<ExtendedRandomExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExtendedRandomExtensionMessage message;

    public ExtendedRandomExtensionSerializer(ExtendedRandomExtensionMessage message) {
        super(message);
        this.message = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        this.writeExtendedRandomLength(this.message);
        this.writeExtendedRandom(this.message);
        return this.getAlreadySerialized();
    }

    private void writeExtendedRandomLength(ExtendedRandomExtensionMessage msg) {
        this.appendInt((Integer)msg.getExtendedRandomLength().getValue(), 2);
        LOGGER.debug("ExtendedRandomLength: " + msg.getExtendedRandomLength().getValue());
    }

    private void writeExtendedRandom(ExtendedRandomExtensionMessage msg) {
        this.appendBytes((byte[])this.message.getExtendedRandom().getValue());
        LOGGER.debug("Serialized Extended Random: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtendedRandom().getValue())));
    }
}

