/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.crypto;

import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.crypto.Encryptor;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordEncryptor
extends Encryptor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TlsContext context;
    private final RecordNullCipher nullCipher;

    public RecordEncryptor(RecordCipher recordCipher, TlsContext context) {
        super(recordCipher);
        this.context = context;
        this.nullCipher = new RecordNullCipher(context);
    }

    @Override
    public void encrypt(BlobRecord record) {
        LOGGER.debug("Encrypting BlobRecord");
        RecordCipher recordCipher = this.getRecordMostRecentCipher();
        try {
            recordCipher.encrypt(record);
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could not encrypt BlobRecord. Using NullCipher", (Throwable)ex);
            try {
                this.nullCipher.encrypt(record);
            }
            catch (CryptoException ex1) {
                LOGGER.error("Could not encrypt with NullCipher", (Throwable)ex1);
            }
        }
        this.context.increaseWriteSequenceNumber();
    }

    @Override
    public void encrypt(Record record) {
        LOGGER.debug("Encrypting Record:");
        RecordCipher recordCipher = this.context.getChooser().getSelectedProtocolVersion().isDTLS() ? this.getRecordCipher((Integer)record.getEpoch().getValue()) : this.getRecordMostRecentCipher();
        try {
            recordCipher.encrypt(record);
        }
        catch (CryptoException ex) {
            LOGGER.warn("Could not encrypt BlobRecord. Using NullCipher", (Throwable)ex);
            try {
                this.nullCipher.encrypt(record);
            }
            catch (CryptoException ex1) {
                LOGGER.error("Could not encrypt with NullCipher", (Throwable)ex1);
            }
        }
        this.context.increaseWriteSequenceNumber();
    }
}

