/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.workflow.action.AsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAsciiAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAsciiAction;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MessageActionFactory {
    public static MessageAction createAction(AliasedConnection connection, ConnectionEndType sendingConnectionEndType, ProtocolMessage ... protocolMessages) {
        return MessageActionFactory.createAction(connection, sendingConnectionEndType, new ArrayList<ProtocolMessage>(Arrays.asList(protocolMessages)));
    }

    public static MessageAction createAction(AliasedConnection connection, ConnectionEndType sendingConnectionEnd, List<ProtocolMessage> protocolMessages) {
        MessageAction action = connection.getLocalConnectionEndType() == sendingConnectionEnd ? new SendAction(protocolMessages) : new ReceiveAction(protocolMessages);
        action.setConnectionAlias(connection.getAlias());
        return action;
    }

    public static AsciiAction createAsciiAction(AliasedConnection connection, ConnectionEndType sendingConnectionEnd, String message, String encoding) {
        AsciiAction action = connection.getLocalConnectionEndType() == sendingConnectionEnd ? new SendAsciiAction(message, encoding) : new GenericReceiveAsciiAction(encoding);
        return action;
    }

    private MessageActionFactory() {
    }
}

