/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geolocation;

import javax.json.JsonObject;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import org.traccar.Context;
import org.traccar.geolocation.GeolocationException;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.model.Network;

public class UniversalGeolocationProvider
implements GeolocationProvider {
    private final String url;

    public UniversalGeolocationProvider(String url, String key) {
        this.url = url + "?key=" + key;
    }

    @Override
    public void getLocation(Network network, final GeolocationProvider.LocationProviderCallback callback) {
        AsyncInvoker invoker = Context.getClient().target(this.url).request().async();
        invoker.post(Entity.json((Object)network), (InvocationCallback)new InvocationCallback<JsonObject>(){

            public void completed(JsonObject json) {
                if (json.containsKey((Object)"error")) {
                    callback.onFailure(new GeolocationException(json.getJsonObject("error").getString("message")));
                } else {
                    JsonObject location = json.getJsonObject("location");
                    callback.onSuccess(location.getJsonNumber("lat").doubleValue(), location.getJsonNumber("lng").doubleValue(), json.getJsonNumber("accuracy").doubleValue());
                }
            }

            public void failed(Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }
}

