/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class MiniFinderProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_FIX = new PatternBuilder().number("(d+)/(d+)/(d+),").number("(d+):(d+):(d+),").number("(-?d+.d+),").number("(-?d+.d+),").compile();
    private static final Pattern PATTERN_STATE = new PatternBuilder().number("(d+.?d*),").number("(d+.?d*),").number("(x+),").number("(-?d+.d+),").number("(d+),").compile();
    private static final Pattern PATTERN_A = new PatternBuilder().text("!A,").expression(PATTERN_FIX.pattern()).any().compile();
    private static final Pattern PATTERN_C = new PatternBuilder().text("!C,").expression(PATTERN_FIX.pattern()).expression(PATTERN_STATE.pattern()).any().compile();
    private static final Pattern PATTERN_BD = new PatternBuilder().expression("![BD],").expression(PATTERN_FIX.pattern()).expression(PATTERN_STATE.pattern()).number("(d+),").number("(d+),").number("(d+.?d*)").compile();

    public MiniFinderProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeFix(Position position, Parser parser) {
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
    }

    private void decodeFlags(Position position, int flags) {
        position.setValid(BitUtil.to(flags, 2) > 0);
        if (BitUtil.check(flags, 1)) {
            position.set("approximate", true);
        }
        if (BitUtil.check(flags, 2)) {
            position.set("alarm", "fault");
        }
        if (BitUtil.check(flags, 6)) {
            position.set("alarm", "sos");
        }
        if (BitUtil.check(flags, 7)) {
            position.set("alarm", "overspeed");
        }
        if (BitUtil.check(flags, 8)) {
            position.set("alarm", "fallDown");
        }
        if (BitUtil.check(flags, 9) || BitUtil.check(flags, 10) || BitUtil.check(flags, 11)) {
            position.set("alarm", "geofence");
        }
        if (BitUtil.check(flags, 12)) {
            position.set("alarm", "lowBattery");
        }
        if (BitUtil.check(flags, 15) || BitUtil.check(flags, 14)) {
            position.set("alarm", "movement");
        }
        position.set("rssi", BitUtil.between(flags, 16, 21));
        position.set("charge", BitUtil.check(flags, 22));
    }

    private void decodeState(Position position, Parser parser) {
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        if (position.getCourse() > 360.0) {
            position.setCourse(0.0);
        }
        this.decodeFlags(position, parser.nextHexInt(0));
        position.setAltitude(parser.nextDouble(0.0));
        position.set("batteryLevel", parser.nextInt(0));
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("!1,")) {
            int index = sentence.indexOf(44, 3);
            if (index < 0) {
                index = sentence.length();
            }
            this.getDeviceSession(channel, remoteAddress, sentence.substring(3, index));
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null || !sentence.matches("![35A-D],.*")) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = sentence.substring(1, 2);
        position.set("type", type);
        if (type.equals("3")) {
            this.getLastLocation(position, null);
            position.set("result", sentence.substring(3));
            return position;
        }
        if (type.equals("5")) {
            String[] values = sentence.split(",");
            this.getLastLocation(position, null);
            position.set("rssi", Integer.parseInt(values[1]));
            if (values.length >= 4) {
                position.set("batteryLevel", Integer.parseInt(values[3]));
            }
            return position;
        }
        if (type.equals("B") || type.equals("D")) {
            Parser parser = new Parser(PATTERN_BD, sentence);
            if (!parser.matches()) {
                return null;
            }
            this.decodeFix(position, parser);
            this.decodeState(position, parser);
            position.set("sat", parser.nextInt(0));
            position.set("satVisible", parser.nextInt(0));
            position.set("hdop", parser.nextDouble(0.0));
            return position;
        }
        if (type.equals("C")) {
            Parser parser = new Parser(PATTERN_C, sentence);
            if (!parser.matches()) {
                return null;
            }
            this.decodeFix(position, parser);
            this.decodeState(position, parser);
            return position;
        }
        if (type.equals("A")) {
            Parser parser = new Parser(PATTERN_A, sentence);
            if (!parser.matches()) {
                return null;
            }
            this.decodeFix(position, parser);
            return position;
        }
        return null;
    }
}

