/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Vt200ProtocolDecoder
extends BaseProtocolDecoder {
    public Vt200ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double decodeCoordinate(int value) {
        int degrees = value / 1000000;
        int minutes = value % 1000000;
        return (double)degrees + (double)minutes * 1.0E-4 / 60.0;
    }

    protected Date decodeDate(ByteBuf buf) {
        DateBuilder dateBuilder = new DateBuilder().setDateReverse(BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2)).setTime(BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2), BcdUtil.readInteger(buf, 2));
        return dateBuilder.getDate();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(1);
        String id = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id);
        if (deviceSession == null) {
            return null;
        }
        int type = buf.readUnsignedShort();
        buf.readUnsignedShort();
        if (type == 8326 || type == 8324 || type == 8322 || type == 12425) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            if (type == 12425) {
                position.set("ignition", buf.readUnsignedByte() == 1);
            } else {
                buf.readUnsignedByte();
            }
            buf.readUnsignedShort();
            position.setTime(this.decodeDate(buf));
            if (buf.readableBytes() > 2) {
                position.setLatitude(Vt200ProtocolDecoder.decodeCoordinate(BcdUtil.readInteger(buf, 8)));
                position.setLongitude(Vt200ProtocolDecoder.decodeCoordinate(BcdUtil.readInteger(buf, 9)));
                short flags = buf.readUnsignedByte();
                position.setValid(BitUtil.check(flags, 0));
                if (!BitUtil.check(flags, 1)) {
                    position.setLatitude(-position.getLatitude());
                }
                if (!BitUtil.check(flags, 2)) {
                    position.setLongitude(-position.getLongitude());
                }
            }
            if (type != 12425) {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.setCourse(buf.readUnsignedByte() * 2);
                position.set("sat", buf.readUnsignedByte());
                position.set("rssi", buf.readUnsignedByte());
                position.set("odometer", buf.readUnsignedInt() * 1000L);
                position.set("status", buf.readUnsignedInt());
            }
            return position;
        }
        if (type == 12424) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            buf.readUnsignedShort();
            buf.skipBytes(8);
            buf.skipBytes(8);
            position.set("tripStart", this.decodeDate(buf).getTime());
            position.set("tripEnd", this.decodeDate(buf).getTime());
            position.set("drivingTime", buf.readUnsignedShort());
            position.set("fuelConsumption", buf.readUnsignedInt());
            position.set("tripOdometer", buf.readUnsignedInt());
            position.set("maxSpeed", UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.set("maxRpm", buf.readUnsignedShort());
            position.set("maxTemp", buf.readUnsignedByte() - 40);
            position.set("hardAccelerationCount", buf.readUnsignedByte());
            position.set("hardBrakingCount", buf.readUnsignedByte());
            for (String speedType : Arrays.asList("over", "high", "normal", "low")) {
                position.set(speedType + "SpeedTime", buf.readUnsignedShort());
                position.set(speedType + "SpeedDistance", buf.readUnsignedInt());
                position.set(speedType + "SpeedFuel", buf.readUnsignedInt());
            }
            position.set("idleTime", buf.readUnsignedShort());
            position.set("idleFuel", buf.readUnsignedInt());
            position.set("hardCorneringCount", buf.readUnsignedByte());
            position.set("overspeedCount", buf.readUnsignedByte());
            position.set("overheatCount", buf.readUnsignedShort());
            position.set("laneChangeCount", buf.readUnsignedByte());
            position.set("emergencyRefueling", buf.readUnsignedByte());
            return position;
        }
        return null;
    }
}

