/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class WliProtocolDecoder
extends BaseProtocolDecoder {
    public WliProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 49) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("index", buf.readUnsignedShort());
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            while (buf.readableBytes() > 1) {
                int endIndex;
                short fieldNumber = buf.readUnsignedByte();
                buf.readUnsignedByte();
                if (buf.getUnsignedByte(buf.readerIndex()) == 255) {
                    buf.readUnsignedByte();
                    endIndex = buf.readUnsignedShort() + buf.readerIndex();
                    if (fieldNumber == 52) {
                        position.setValid(true);
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                        position.setFixTime(dateBuilder.getDate());
                        position.setLatitude((double)buf.readInt() / 600000.0);
                        position.setLongitude((double)buf.readInt() / 600000.0);
                        position.setSpeed(buf.readUnsignedShort());
                        position.setCourse((double)buf.readUnsignedShort() * 0.1);
                        position.set("odometer", UnitsConverter.metersFromFeet(buf.readUnsignedInt()));
                        position.setAltitude((double)buf.readInt() * 0.1);
                    }
                    buf.readerIndex(endIndex);
                } else {
                    endIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0);
                    String value = buf.readCharSequence(endIndex - buf.readerIndex(), StandardCharsets.US_ASCII).toString();
                    switch (fieldNumber) {
                        case 246: {
                            String[] values = value.split(",");
                            position.set("power", (double)Integer.parseInt(values[2]) * 0.01);
                            position.set("battery", (double)Integer.parseInt(values[3]) * 0.01);
                            break;
                        }
                        case 255: {
                            position.setDeviceTime(new Date(Long.parseLong(value) * 1000L));
                            break;
                        }
                    }
                }
                buf.readUnsignedByte();
            }
            if (!position.getValid()) {
                this.getLastLocation(position, position.getDeviceTime());
            }
            return position;
        }
        if (type == 50) {
            String id = buf.toString(buf.readerIndex(), buf.readableBytes() - 1, StandardCharsets.US_ASCII);
            this.getDeviceSession(channel, remoteAddress, id.substring("wli:".length()));
            return null;
        }
        return null;
    }
}

