/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import liquibase.GlobalConfiguration;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class ChangeLogWriter {
    protected File outputDir;
    private ResourceAccessor resourceAccessor;

    public ChangeLogWriter(ResourceAccessor resourceAccessor, File rootOutputDir) {
        this.outputDir = new File(rootOutputDir, "changelogs");
        this.resourceAccessor = resourceAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChangeLog(String changeLog, String physicalFilePath) throws IOException {
        String changeLogOutFile = changeLog.replace(":", "_");
        File xmlFile = new File(this.outputDir, changeLogOutFile.toLowerCase() + ".html");
        xmlFile.getParentFile().mkdirs();
        try (BufferedWriter changeLogStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile, false), GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
             InputStream stylesheet = this.resourceAccessor.openStream(null, physicalFilePath);){
            if (stylesheet == null) {
                throw new IOException("Can not find " + changeLog);
            }
            changeLogStream.write("<html><body><pre>\n");
            changeLogStream.write(StreamUtil.readStreamAsString(stylesheet).replace("<", "&lt;").replace(">", "&gt;"));
            changeLogStream.write("\n</pre></body></html>");
        }
    }
}

