/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.IOException;
import java.io.Writer;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.AbstractChangeLogBasedTask;
import liquibase.repackaged.org.apache.tools.ant.BuildException;

public class DatabaseRollbackFutureTask
extends AbstractChangeLogBasedTask {
    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        Liquibase liquibase = this.getLiquibase();
        try (Writer outputFileWriter = this.getOutputFileWriter();){
            liquibase.futureRollbackSQL(new Contexts(this.getContexts()), this.getLabels(), outputFileWriter);
        }
        catch (LiquibaseException e2) {
            throw new BuildException("Unable to generate future rollback SQL: " + e2.getMessage(), (Throwable)e2);
        }
        catch (IOException e3) {
            throw new BuildException("Unable to generate future rollback SQL. Error creating output writer.", (Throwable)e3);
        }
    }

    @Override
    protected void validateParameters() {
        super.validateParameters();
        if (this.getOutputFile() == null) {
            throw new BuildException("Output file is required.");
        }
    }
}

