/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class ApelProtocolDecoder
extends BaseProtocolDecoder {
    private long lastIndex;
    private long newIndex;
    public static final short MSG_NULL = 0;
    public static final short MSG_REQUEST_TRACKER_ID = 10;
    public static final short MSG_TRACKER_ID = 11;
    public static final short MSG_TRACKER_ID_EXT = 12;
    public static final short MSG_DISCONNECT = 20;
    public static final short MSG_REQUEST_PASSWORD = 30;
    public static final short MSG_PASSWORD = 31;
    public static final short MSG_REQUEST_STATE_FULL_INFO = 90;
    public static final short MSG_STATE_FULL_INFO_T104 = 92;
    public static final short MSG_REQUEST_CURRENT_GPS_DATA = 100;
    public static final short MSG_CURRENT_GPS_DATA = 101;
    public static final short MSG_REQUEST_SENSORS_STATE = 110;
    public static final short MSG_SENSORS_STATE = 111;
    public static final short MSG_SENSORS_STATE_T100 = 112;
    public static final short MSG_SENSORS_STATE_T100_4 = 113;
    public static final short MSG_REQUEST_LAST_LOG_INDEX = 120;
    public static final short MSG_LAST_LOG_INDEX = 121;
    public static final short MSG_REQUEST_LOG_RECORDS = 130;
    public static final short MSG_LOG_RECORDS = 131;
    public static final short MSG_EVENT = 141;
    public static final short MSG_TEXT = 150;
    public static final short MSG_ACK_ALARM = 160;
    public static final short MSG_SET_TRACKER_MODE = 170;
    public static final short MSG_GPRS_COMMAND = 180;

    public ApelProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendSimpleMessage(Channel channel, short type) {
        ByteBuf request = Unpooled.buffer((int)8);
        request.writeShortLE((int)type);
        request.writeShortLE(0);
        request.writeIntLE(Checksum.crc32(request.nioBuffer(0, 4)));
        channel.writeAndFlush((Object)new NetworkMessage(request, channel.remoteAddress()));
    }

    private void requestArchive(Channel channel) {
        if (this.lastIndex == 0L) {
            this.lastIndex = this.newIndex;
        } else if (this.newIndex > this.lastIndex) {
            ByteBuf request = Unpooled.buffer((int)14);
            request.writeShortLE(130);
            request.writeShortLE(6);
            request.writeIntLE((int)this.lastIndex);
            request.writeShortLE(512);
            request.writeIntLE(Checksum.crc32(request.nioBuffer(0, 10)));
            channel.writeAndFlush((Object)new NetworkMessage(request, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int type = buf.readUnsignedShortLE();
        boolean alarm = (type & 0x8000) != 0;
        type &= Short.MAX_VALUE;
        buf.readUnsignedShortLE();
        if (alarm) {
            this.sendSimpleMessage(channel, (short)160);
        }
        if (type == 11) {
            return null;
        }
        if (type == 12) {
            buf.readUnsignedIntLE();
            int length = buf.readUnsignedShortLE();
            buf.skipBytes(length);
            length = buf.readUnsignedShortLE();
            this.getDeviceSession(channel, remoteAddress, buf.readSlice(length).toString(StandardCharsets.US_ASCII));
        } else if (type == 121) {
            long index = buf.readUnsignedIntLE();
            if (index > 0L) {
                this.newIndex = index;
                this.requestArchive(channel);
            }
        } else if (type == 101 || type == 92 || type == 131) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            int recordCount = 1;
            if (type == 131) {
                recordCount = buf.readUnsignedShortLE();
            }
            for (int j = 0; j < recordCount; ++j) {
                short speed;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                int subtype = type;
                if (type == 131) {
                    position.set("archive", true);
                    this.lastIndex = buf.readUnsignedIntLE() + 1L;
                    position.set("index", this.lastIndex);
                    subtype = buf.readUnsignedShortLE();
                    if (subtype != 101 && subtype != 92) {
                        buf.skipBytes(buf.readUnsignedShortLE());
                        continue;
                    }
                    buf.readUnsignedShortLE();
                }
                position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
                position.setLatitude((double)buf.readIntLE() * 180.0 / 2.147483647E9);
                position.setLongitude((double)buf.readIntLE() * 180.0 / 2.147483647E9);
                if (subtype == 92) {
                    speed = buf.readUnsignedByte();
                    position.setValid(speed != 255);
                    position.setSpeed(UnitsConverter.knotsFromKph(speed));
                    position.set("hdop", buf.readByte());
                } else {
                    speed = buf.readShortLE();
                    position.setValid(speed != -1);
                    position.setSpeed(UnitsConverter.knotsFromKph((double)speed * 0.01));
                }
                position.setCourse((double)buf.readShortLE() * 0.01);
                position.setAltitude(buf.readShortLE());
                if (subtype == 92) {
                    position.set("sat", buf.readUnsignedByte());
                    position.set("rssi", buf.readUnsignedByte());
                    position.set("event", buf.readUnsignedShortLE());
                    position.set("odometer", buf.readUnsignedIntLE());
                    position.set("input", buf.readUnsignedByte());
                    position.set("output", buf.readUnsignedByte());
                    for (int i = 1; i <= 8; ++i) {
                        position.set("adc" + i, buf.readUnsignedShortLE());
                    }
                    position.set("count1", buf.readUnsignedIntLE());
                    position.set("count2", buf.readUnsignedIntLE());
                    position.set("count3", buf.readUnsignedIntLE());
                }
                positions.add(position);
            }
            buf.readUnsignedIntLE();
            if (type == 131) {
                this.requestArchive(channel);
            } else {
                this.sendSimpleMessage(channel, (short)120);
            }
            return positions;
        }
        return null;
    }
}

