/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Gt02ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATA = 16;
    public static final int MSG_HEARTBEAT = 26;
    public static final int MSG_RESPONSE = 28;

    public Gt02ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readByte();
        Position position = new Position(this.getProtocolName());
        short power = buf.readUnsignedByte();
        short gsm = buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("index", buf.readUnsignedShort());
        short type = buf.readUnsignedByte();
        if (type == 26) {
            this.getLastLocation(position, null);
            position.set("power", Integer.valueOf(power));
            position.set("rssi", Integer.valueOf(gsm));
            if (channel != null) {
                byte[] response = new byte[]{84, 104, 26, 13, 10};
                channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])response), remoteAddress));
            }
        } else if (type == 16) {
            DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
            double latitude = (double)buf.readUnsignedInt() / 1800000.0;
            double longitude = (double)buf.readUnsignedInt() / 1800000.0;
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.setCourse(buf.readUnsignedShort());
            buf.skipBytes(3);
            long flags = buf.readUnsignedInt();
            position.setValid(BitUtil.check(flags, 0));
            if (!BitUtil.check(flags, 1)) {
                latitude = -latitude;
            }
            if (!BitUtil.check(flags, 2)) {
                longitude = -longitude;
            }
            position.setLatitude(latitude);
            position.setLongitude(longitude);
        } else if (type == 28) {
            this.getLastLocation(position, null);
            position.set("result", buf.readSlice((int)buf.readUnsignedByte()).toString(StandardCharsets.US_ASCII));
        } else {
            return null;
        }
        return position;
    }
}

