/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class TekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number(",d+,").number("(dd)(dd)(dd).d,").number("(dd)(dd.d+)").expression("([NS]),").number("(ddd)(dd.d+)").expression("([EW]),").number("(d+.d+),").number("(d+.d+),").number("(d+),").number("(d+.d+),").number("d+.d+,").number("(d+.d+),").number("(dd)(dd)(dd),").number("(d+),").any().compile();

    public TekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        int type = BitUtil.to(buf.readUnsignedByte(), 6);
        buf.readUnsignedByte();
        if (type == 4 || type == 8) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            int count = buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                position.set("rssi" + (i + 1), buf.readUnsignedByte());
                position.set("temp" + (i + 1), buf.readUnsignedByte() - 30);
                int data = buf.readUnsignedShort();
                position.set("src" + (i + 1), BitUtil.from(data, 10));
                position.set("ullage" + (i + 1), BitUtil.to(data, 10));
            }
            return position;
        }
        if (type == 17) {
            String sentence = buf.toString(StandardCharsets.US_ASCII);
            Parser parser = new Parser(PATTERN, sentence);
            if (!parser.matches()) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setLatitude(parser.nextCoordinate());
            position.setLongitude(parser.nextCoordinate());
            position.set("hdop", parser.nextDouble());
            position.setAltitude(parser.nextDouble());
            position.setValid(parser.nextInt() > 0);
            position.setCourse(parser.nextDouble());
            position.setSpeed(parser.nextDouble());
            dateBuilder.setDateReverse(parser.nextInt(), parser.nextInt(), parser.nextInt());
            position.setTime(dateBuilder.getDate());
            return position;
        }
        return null;
    }
}

