/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.pattern.ManyPattern;
import org.jparsec.pattern.Pattern;
import org.jparsec.pattern.RepeatPattern;

class LowerBoundedPattern
extends Pattern {
    private final int min;
    private final Pattern pattern;

    LowerBoundedPattern(int min, Pattern pattern) {
        this.min = min;
        this.pattern = pattern;
    }

    @Override
    public int match(CharSequence src, int begin, int end) {
        int minLen = RepeatPattern.matchRepeat(this.min, this.pattern, src, end, begin, 0);
        if (-1 == minLen) {
            return -1;
        }
        return ManyPattern.matchMany(this.pattern, src, end, begin + minLen, minLen);
    }

    public String toString() {
        return this.min > 1 ? this.pattern + "{" + this.min + ",}" : this.pattern + "+";
    }
}

