/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.RuleListener;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.RulesEngineListener;
import com.datical.liquibase.ext.rules.api.RulesEngineParameters;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import com.datical.liquibase.ext.rules.core.DefaultRulesEngine;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.logging.Logger;

public final class InferenceRulesEngine
extends AbstractRulesEngine {
    private final DefaultRulesEngine delegate;

    public InferenceRulesEngine() {
        this(new RulesEngineParameters());
    }

    public InferenceRulesEngine(RulesEngineParameters rulesEngineParameters) {
        super(rulesEngineParameters);
        this.delegate = new DefaultRulesEngine(rulesEngineParameters);
    }

    @Override
    public final void fire(Rules rules, Facts facts) {
        Set<Rule> set;
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        do {
            logger.fine("Selecting candidate com.datical.liquibase.ext.rules based on the following facts: ".concat(String.valueOf(facts)));
            set = this.selectCandidates(rules, facts);
            if (!set.isEmpty()) {
                this.delegate.fire(new Rules(set), facts);
                continue;
            }
            logger.fine("No candidate com.datical.liquibase.ext.rules found for facts: ".concat(String.valueOf(facts)));
        } while (!set.isEmpty());
    }

    private Set<Rule> selectCandidates(Rules object, Facts facts) {
        TreeSet<Rule> treeSet = new TreeSet<Rule>();
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            Rule rule = (Rule)object.next();
            if (!rule.evaluate(facts)) continue;
            treeSet.add(rule);
        }
        return treeSet;
    }

    @Override
    public final Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        return this.delegate.check(rules, facts);
    }

    @Override
    public final void registerRuleListener(RuleListener ruleListener) {
        super.registerRuleListener(ruleListener);
        this.delegate.registerRuleListener(ruleListener);
    }

    @Override
    public final void registerRuleListeners(List<RuleListener> list) {
        super.registerRuleListeners(list);
        this.delegate.registerRuleListeners(list);
    }

    @Override
    public final void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        super.registerRulesEngineListener(rulesEngineListener);
        this.delegate.registerRulesEngineListener(rulesEngineListener);
    }

    @Override
    public final void registerRulesEngineListeners(List<RulesEngineListener> list) {
        super.registerRulesEngineListeners(list);
        this.delegate.registerRulesEngineListeners(list);
    }
}

