/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.util.List;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.ObjectStore;
import jde.debugger.command.DebugProcessCommand;

public class TraceThreads
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String type = this.m_args.remove(0).toString().toLowerCase();
        if (!type.equals("start") && !type.equals("death")) {
            throw new JDEException("Invalid type");
        }
        List classFilters = Etc.getClassFiltersFromArgs(this.m_args);
        List classExFilters = Etc.getClassExFiltersFromArgs(this.m_args);
        EventRequestManager em = this.m_debugger.getVM().eventRequestManager();
        Long requestID = null;
        ObjectStore store = this.m_debugger.getStore();
        if (type.equals("start")) {
            ThreadStartRequest ter = em.createThreadStartRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
            if (this.m_args.size() > 0) {
                Long threadID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
                ObjectReference tRef = store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.m_debugger.addIdentifiableRequest(ter);
        } else if (type.equals("death")) {
            ThreadDeathRequest ter = em.createThreadDeathRequest();
            ter.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
            if (this.m_args.size() > 0) {
                Long threadID = Etc.safeGetLong(this.m_args.remove(0), "thread ID");
                ObjectReference tRef = store.get(threadID);
                if (tRef == null) {
                    throw new JDEException("No such thread exists");
                }
                if (!(tRef instanceof ThreadReference)) {
                    throw new JDEException("No such thread exists (anymore?)");
                }
                ter.addThreadFilter((ThreadReference)tRef);
            }
            requestID = this.m_debugger.addIdentifiableRequest(ter);
        }
        this.m_debugger.signalCommandResult(this.m_cmdID, requestID.toString(), true);
    }

    public Object clone() {
        return new TraceThreads();
    }
}

