/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.GetVersionedObjectTask;
import ghidra.framework.main.datatree.CopyFileVersionTask;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeFlavorHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.VersionInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;

public final class LocalVersionInfoHandler
implements DataTreeFlavorHandler,
FileOpenDataFlavorHandler {
    @Override
    public void handle(PluginTool tool, Object obj, DropTargetDropEvent e, DataFlavor f) {
        VersionInfo info = (VersionInfo)obj;
        DomainFile file = tool.getProject().getProjectData().getFile(info.getDomainFilePath());
        GetVersionedObjectTask task = new GetVersionedObjectTask(this, file, info.getVersionNumber());
        tool.execute(task, 250);
        DomainObject versionedObj = task.getVersionedObject();
        if (versionedObj != null) {
            DomainFile vfile = versionedObj.getDomainFile();
            tool.acceptDomainFiles(new DomainFile[]{vfile});
            versionedObj.release(this);
        }
    }

    @Override
    public void handle(PluginTool tool, DataTree dataTree, GTreeNode destinationNode, Object transferData, int dropAction) {
        DomainFolder folder = this.getDomainFolder(destinationNode);
        VersionInfo info = (VersionInfo)transferData;
        RepositoryAdapter rep = tool.getProject().getProjectData().getRepository();
        try {
            DomainFile file;
            if (rep != null) {
                rep.connect();
            }
            if ((file = tool.getProject().getProjectData().getFile(info.getDomainFilePath())) != null) {
                new TaskLauncher((Task)new CopyFileVersionTask(file, info.getVersionNumber(), folder), (Component)((Object)dataTree), 500);
            }
        }
        catch (NotConnectedException file) {
        }
        catch (IOException exc) {
            ClientUtil.handleException((RepositoryAdapter)rep, (Exception)exc, (String)"Repository Connection", (Component)tool.getToolFrame());
        }
    }

    private DomainFolder getDomainFolder(GTreeNode destinationNode) {
        if (destinationNode instanceof DomainFolderNode) {
            return ((DomainFolderNode)destinationNode).getDomainFolder();
        }
        if (destinationNode instanceof DomainFileNode) {
            DomainFolderNode parent = (DomainFolderNode)destinationNode.getParent();
            return parent.getDomainFolder();
        }
        return null;
    }
}

