/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.file.formats.bplist.BinaryPropertyListUtil;
import ghidra.file.formats.bplist.NSObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NSArray
extends NSObject {
    private List<Integer> values = new ArrayList<Integer>();
    private int objectRefSize;

    public NSArray(int objectRefSize) {
        this.objectRefSize = objectRefSize;
    }

    @Override
    public String getType() {
        return "NSArray";
    }

    @Override
    public void markup(Data objectData, Program program, TaskMonitor monitor) throws CancelledException {
        ReferenceManager referenceManager = program.getReferenceManager();
        for (int i = 0; i < objectData.getNumComponents(); ++i) {
            long value;
            String name;
            Symbol symbol;
            monitor.checkCanceled();
            Data component = objectData.getComponent(i);
            if (!component.getFieldName().startsWith("value") || (symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)(name = BinaryPropertyListUtil.generateName(value = this.getValue(component))), err -> Msg.error((Object)this, (Object)err))) == null) continue;
            referenceManager.addMemoryReference(component.getMinAddress(), symbol.getAddress(), RefType.DATA, SourceType.ANALYSIS, 0);
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("NSArray_" + this.values.size(), 0);
        this.addHeader((Structure)structure, this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.objectRefSize == 1) {
                structure.add(BYTE, "value" + i, null);
                continue;
            }
            if (this.objectRefSize == 2) {
                structure.add(WORD, "value" + i, null);
                continue;
            }
            if (this.objectRefSize == 4) {
                structure.add(DWORD, "value" + i, null);
                continue;
            }
            if (this.objectRefSize == 8) {
                structure.add(QWORD, "value" + i, null);
                continue;
            }
            throw new RuntimeException();
        }
        return structure;
    }

    public void add(int value) {
        this.values.add(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NSArray {");
        for (int i = 0; i < this.values.size(); ++i) {
            builder.append("{0x" + Integer.toHexString(this.values.get(i)) + "}");
        }
        builder.append("}");
        return builder.toString();
    }
}

