/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class ArmSymbolAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "ARM Symbol";
    private static final String DESCRIPTION = "Analyze bytes for Thumb symbols and shift -1 as necessary.";

    public ArmSymbolAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.before().before().before().before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        monitor.setMessage("ARM/Thumb symbol analyzer");
        Memory memory = program.getMemory();
        SymbolIterator it = program.getSymbolTable().getPrimarySymbolIterator(set, true);
        while (it.hasNext() && !monitor.isCancelled()) {
            MemoryBlock block;
            Symbol primarySymbol = it.next();
            Address address = primarySymbol.getAddress();
            if (!address.isMemoryAddress() || (block = memory.getBlock(address)) == null || !block.isExecute() || (address.getOffset() & 1L) != 1L) continue;
            Address newAddress = address.subtract(1L);
            this.moveFunction(program, address, newAddress);
            this.moveSymbols(program, address, newAddress);
            this.updateEntryPoint(program, address, newAddress);
            this.setTModeRegister(program, newAddress);
        }
        return true;
    }

    private void setTModeRegister(Program program, Address newAddress) {
        Listing listing = program.getListing();
        Register TModeRegister = program.getRegister("TMode");
        if (listing.getUndefinedDataAt(newAddress) != null) {
            try {
                program.getProgramContext().setValue(TModeRegister, newAddress, newAddress, new BigInteger("1"));
            }
            catch (ContextChangeException e) {
                Msg.error((Object)this, (Object)"Unexpected Error", (Throwable)e);
            }
        }
    }

    private void updateEntryPoint(Program program, Address address, Address newAddress) {
        SymbolTable symbolTable = program.getSymbolTable();
        if (symbolTable.isExternalEntryPoint(address)) {
            symbolTable.removeExternalEntryPoint(address);
            symbolTable.addExternalEntryPoint(newAddress);
        }
    }

    private void moveSymbols(Program program, Address address, Address newAddress) {
        Symbol[] symbols;
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol primary = symbolTable.getPrimarySymbol(address);
        if (primary == null || primary.getSource() == SourceType.DEFAULT) {
            return;
        }
        this.createLabel(symbolTable, newAddress, primary.getName(), primary.getSource());
        for (Symbol s : symbols = symbolTable.getSymbols(address)) {
            if (s == primary) continue;
            this.createLabel(symbolTable, newAddress, s.getName(), s.getSource());
            s.delete();
        }
        primary.delete();
    }

    private void moveFunction(Program program, Address address, Address newAddress) {
        FunctionManager functionManager = program.getFunctionManager();
        Function func = functionManager.getFunctionAt(address);
        if (func != null) {
            functionManager.removeFunction(address);
            functionManager.removeFunction(newAddress);
            try {
                AddressSet body = new AddressSet(newAddress);
                functionManager.createFunction(null, newAddress, (AddressSetView)body, SourceType.DEFAULT);
            }
            catch (OverlappingFunctionException | InvalidInputException e) {
                Msg.error((Object)this, (Object)"Error creating function", (Throwable)e);
            }
        }
    }

    private void createLabel(SymbolTable symbolTable, Address address, String name, SourceType sourceType) {
        try {
            symbolTable.createLabel(address, name, sourceType);
        }
        catch (InvalidInputException e) {
            throw new AssertException("This should never happen!", (Throwable)e);
        }
    }

    @Override
    public void analysisEnded(Program program) {
    }

    @Override
    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM")) && program.getRegister("TMode") != null;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        return true;
    }
}

