/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.interpreter;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.core.interpreter.InterpreterConnection;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.plugin.core.interpreter.InterpreterPanel;
import ghidra.app.plugin.core.interpreter.InterpreterPanelPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.Icons;
import resources.ResourceManager;
import utility.function.Callback;

public class InterpreterComponentProvider
extends ComponentProviderAdapter
implements InterpreterConsole {
    private static final String CONSOLE_GIF = "images/monitor.png";
    private static final String CLEAR_GIF = "images/erase16.png";
    private InterpreterPanel panel;
    private InterpreterConnection interpreter;
    private List<Callback> firstActivationCallbacks;

    public InterpreterComponentProvider(InterpreterPanelPlugin plugin, InterpreterConnection interpreter, boolean visible) {
        super(plugin.getTool(), interpreter.getTitle(), plugin.getName());
        this.panel = new InterpreterPanel(plugin.getTool(), interpreter);
        this.interpreter = interpreter;
        this.firstActivationCallbacks = new ArrayList<Callback>();
        this.setHelpLocation(new HelpLocation(this.getName(), "interpreter"));
        this.addToTool();
        this.createActions();
        ImageIcon icon = interpreter.getIcon();
        if (icon == null) {
            icon = ResourceManager.loadImage((String)CONSOLE_GIF);
        }
        this.setIcon(icon);
        this.setVisible(visible);
    }

    private void createActions() {
        DockingAction clearAction = new DockingAction("Clear Interpreter", this.getName()){

            public void actionPerformed(ActionContext context) {
                InterpreterComponentProvider.this.clear();
            }
        };
        clearAction.setDescription("Clear Interpreter");
        clearAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)CLEAR_GIF), null));
        clearAction.setEnabled(true);
        this.addLocalAction((DockingActionIf)clearAction);
    }

    @Override
    public void addAction(DockingAction action) {
        this.addLocalAction((DockingActionIf)action);
    }

    @Override
    public void setTransient() {
        DockingAction disposeAction = new DockingAction("Remove Interpreter", this.getName()){

            public void actionPerformed(ActionContext context) {
                int choice = OptionDialog.showYesNoDialog((Component)InterpreterComponentProvider.this.panel, (String)"Remove Interpreter?", (String)"Are you sure you want to permanently close the interpreter?");
                if (choice == 2) {
                    return;
                }
                InterpreterComponentProvider.this.dispose();
            }
        };
        disposeAction.setDescription("Remove interpreter from tool");
        disposeAction.setToolBarData(new ToolBarData((Icon)Icons.STOP_ICON, null));
        disposeAction.setEnabled(true);
        this.addLocalAction((DockingActionIf)disposeAction);
    }

    public String getWindowSubMenuName() {
        return this.interpreter.getTitle();
    }

    public String getTitle() {
        return this.interpreter.getTitle();
    }

    public String getSubTitle() {
        return "Interpreter";
    }

    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public void clear() {
        this.panel.clear();
    }

    @Override
    public InputStream getStdin() {
        return this.panel.getStdin();
    }

    @Override
    public OutputStream getStdOut() {
        return this.panel.getStdOut();
    }

    @Override
    public OutputStream getStdErr() {
        return this.panel.getStdErr();
    }

    @Override
    public PrintWriter getOutWriter() {
        return this.panel.getOutWriter();
    }

    @Override
    public PrintWriter getErrWriter() {
        return this.panel.getErrWriter();
    }

    @Override
    public void setPrompt(String prompt) {
        this.panel.setPrompt(prompt);
    }

    public void dispose() {
        this.removeFromTool();
        this.panel.dispose();
    }

    public void componentActivated() {
        ArrayList<Callback> callbacks = new ArrayList<Callback>(this.firstActivationCallbacks);
        this.firstActivationCallbacks.clear();
        callbacks.forEach(l -> l.call());
    }

    @Override
    public void addFirstActivationCallback(Callback activationCallback) {
        this.firstActivationCallbacks.add(activationCallback);
    }
}

