/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.Icons;

public class MakeProgramSelectionAction
extends DockingAction {
    private Plugin plugin;
    private GhidraTable table;

    public MakeProgramSelectionAction(String owner, GhidraTable table) {
        super("Make Selection", owner, KeyBindingType.SHARED);
    }

    public MakeProgramSelectionAction(Plugin plugin, GhidraTable table) {
        super("Make Selection", plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.table = table;
        this.setPopupMenuData(new MenuData(new String[]{"Make Selection"}, (Icon)Icons.MAKE_SELECTION_ICON));
        this.setToolBarData(new ToolBarData((Icon)Icons.MAKE_SELECTION_ICON));
        this.setDescription("Make a program selection from the seleted rows");
        this.setHelpLocation(new HelpLocation("Search", "Make_Selection"));
        this.initKeyStroke(null);
    }

    private void initKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        this.setKeyBindingData(new KeyBindingData(keyStroke));
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        Component component = context.getSourceComponent();
        if (component != this.table) {
            return false;
        }
        Program program = this.table.getProgram();
        if (program == null) {
            return false;
        }
        if (program.isClosed()) {
            return false;
        }
        int n = this.table.getSelectedRowCount();
        return n > 0;
    }

    public void actionPerformed(ActionContext context) {
        this.makeSelection(context);
    }

    protected ProgramSelection makeSelection(ActionContext context) {
        ProgramSelection selection = this.table.getProgramSelection();
        if (this.plugin == null) {
            throw new IllegalStateException("The Make Program Selection action cannot be used without a plugin unless the client overrides this method");
        }
        ProgramSelectionPluginEvent event = new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.table.getProgram());
        this.plugin.firePluginEvent((PluginEvent)event);
        return selection;
    }
}

