/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.table.field.ProgramBasedDynamicTableColumnExtensionPoint;

public class SymbolTypeTableColumn
extends ProgramBasedDynamicTableColumnExtensionPoint<ProgramLocation, String> {
    public String getColumnName() {
        return "Symbol Type";
    }

    public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Symbol symbol;
        if (rowObject instanceof VariableLocation) {
            VariableLocation varLoc = (VariableLocation)rowObject;
            return varLoc.isParameter() ? SymbolType.PARAMETER.toString() : SymbolType.LOCAL_VAR.toString();
        }
        SymbolTable symbolTable = program.getSymbolTable();
        if (rowObject instanceof LabelFieldLocation) {
            LabelFieldLocation labLoc = (LabelFieldLocation)rowObject;
            symbol = labLoc.getSymbol();
        } else {
            symbol = symbolTable.getPrimarySymbol(rowObject.getAddress());
        }
        if (symbol == null) {
            return null;
        }
        return SymbolUtilities.getSymbolTypeDisplayName((Symbol)symbol);
    }
}

