/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.WrappedOption;
import java.io.File;

public class WrappedFile
implements WrappedOption {
    private static final String FILE = "file";
    private File file;

    public String toString() {
        return "WrappedFile: " + this.file.getAbsolutePath();
    }

    public WrappedFile(File file) {
        this.file = file;
    }

    public WrappedFile() {
    }

    @Override
    public void readState(SaveState saveState) {
        String filePath = saveState.getString(FILE, ".");
        this.file = new File(filePath);
    }

    @Override
    public void writeState(SaveState saveState) {
        saveState.putString(FILE, this.file.getAbsolutePath());
    }

    @Override
    public Object getObject() {
        return this.file;
    }

    @Override
    public OptionType getOptionType() {
        return OptionType.FILE_TYPE;
    }
}

