/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class CopyOnReadWeakSet<T>
extends WeakSet<T> {
    protected CopyOnReadWeakSet() {
    }

    @Override
    public synchronized void add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        this.weakHashStorage.put(t, null);
    }

    @Override
    public synchronized void remove(T t) {
        this.weakHashStorage.remove(t);
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage.clear();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        Set ks = this.weakHashStorage.keySet();
        ArrayList list = new ArrayList(ks);
        return list.iterator();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.weakHashStorage.keySet();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public synchronized boolean contains(T t) {
        return this.weakHashStorage.containsKey(t);
    }
}

