/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.validator.DuplicateAnchorCollection;
import help.validator.model.AnchorDefinition;
import help.validator.model.HelpFile;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class DuplicateAnchorCollectionByHelpFile
implements DuplicateAnchorCollection,
Comparable<DuplicateAnchorCollectionByHelpFile> {
    private final HelpFile helpFile;
    private final Map<String, List<AnchorDefinition>> duplicateAnchors;

    DuplicateAnchorCollectionByHelpFile(HelpFile helpFile, Map<String, List<AnchorDefinition>> duplicateAnchors) {
        this.helpFile = helpFile;
        this.duplicateAnchors = duplicateAnchors;
    }

    public HelpFile getHelpFile() {
        return this.helpFile;
    }

    public String toString() {
        return "Duplicate anchors for file\n\tfile:    " + this.helpFile + "\n\tanchor:  " + this.getAnchorsAsString();
    }

    private String getAnchorsAsString() {
        StringBuilder buildy = new StringBuilder();
        for (Map.Entry<String, List<AnchorDefinition>> entry : this.duplicateAnchors.entrySet()) {
            buildy.append("Generated ID: ").append(entry.getKey()).append('\n');
            List<AnchorDefinition> list = entry.getValue();
            for (AnchorDefinition anchorDefinition : list) {
                buildy.append('\t').append('\t').append(anchorDefinition).append('\n');
            }
        }
        return buildy.toString();
    }

    @Override
    public int compareTo(DuplicateAnchorCollectionByHelpFile o) {
        HelpFile helpFile1 = this.getHelpFile();
        HelpFile helpFile2 = o.getHelpFile();
        Path file1 = helpFile1.getFile();
        Path file2 = helpFile2.getFile();
        return file1.compareTo(file2);
    }
}

