/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;

public class BeanMemento
extends ComponentMemento {
    static final long serialVersionUID = -92122133275350884L;
    public static final int VERSION = 2;
    private String m_jetabean_class;
    private String m_bean_class;
    private PropertiesMemento m_properties;
    private byte[] m_bean_xml;
    private Collection m_custom_properties;

    public boolean containsProperty(String string) {
        if (this.m_properties != null) {
            return this.m_properties.containsProperty(string);
        }
        return false;
    }

    public Collection getCustomProperties() {
        return this.m_custom_properties;
    }

    public String getJETABeanClass() {
        return this.m_jetabean_class;
    }

    public String getBeanClass() {
        return this.m_bean_class;
    }

    public byte[] getBeanXML() {
        return this.m_bean_xml;
    }

    public PropertiesMemento getProperties() {
        return this.m_properties;
    }

    public void print() {
        System.out.println("     BeanMemento state.................. ");
        System.out.println("           jetabean: " + this.m_jetabean_class);
        System.out.println("           bean_class: " + this.m_bean_class);
    }

    public void setCustomProperties(Collection collection) {
        this.m_custom_properties = collection;
    }

    public void setBeanClass(String string) {
        this.m_bean_class = string;
    }

    public void setJETABeanClass(String string) {
        this.m_jetabean_class = string;
    }

    public void setBeanXML(byte[] byArray) {
        this.m_bean_xml = byArray;
    }

    public void setProperties(PropertiesMemento propertiesMemento) {
        this.m_properties = propertiesMemento;
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        super.read(jETAObjectInput.getSuperClassInput());
        int n = jETAObjectInput.readVersion();
        this.m_jetabean_class = jETAObjectInput.readString("jetabeanclass");
        this.m_bean_class = jETAObjectInput.readString("beanclass");
        if (n == 1) {
            this.m_bean_xml = (byte[])jETAObjectInput.readObject("bean_xml");
            this.m_custom_properties = (Collection)jETAObjectInput.readObject("custom_properties");
            this.m_properties = null;
        } else {
            Object object = jETAObjectInput.readObject("beanproperties");
            if (object instanceof byte[]) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.m_properties = (PropertiesMemento)objectInputStream.readObject();
            } else if (object instanceof PropertiesMemento) {
                this.m_properties = (PropertiesMemento)object;
            }
        }
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        super.write(jETAObjectOutput.getSuperClassOutput(ComponentMemento.class));
        jETAObjectOutput.writeVersion(2);
        jETAObjectOutput.writeObject("jetabeanclass", this.m_jetabean_class);
        jETAObjectOutput.writeObject("beanclass", this.m_bean_class);
        jETAObjectOutput.writeObject("beanproperties", this.m_properties);
    }
}

