/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.PointerDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class PointerDBAdapterV2
extends PointerDBAdapter {
    static final int VERSION = 2;
    private Table table;

    PointerDBAdapterV2(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Pointers", SCHEMA, new int[]{1});
        } else {
            this.table = handle.getTable("Pointers");
            if (this.table == null) {
                throw new VersionException("Missing Table: Pointers");
            }
            if (this.table.getSchema().getVersion() != 2) {
                int version = this.table.getSchema().getVersion();
                if (version < 2) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    Record createRecord(long dataTypeID, long categoryID, int length) throws IOException {
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(4, tableKey);
        Record record = SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        record.setLongValue(1, categoryID);
        record.setByteValue(2, (byte)length);
        this.table.putRecord(record);
        return record;
    }

    @Override
    Record getRecord(long pointerID) throws IOException {
        return this.table.getRecord(pointerID);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    boolean removeRecord(long pointerID) throws IOException {
        return this.table.deleteRecord(pointerID);
    }

    @Override
    void updateRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 1);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Pointers");
    }
}

