/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.properties.HelpAction;
import org.openstreetmap.josm.gui.tagging.presets.items.TextItem;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class Link
extends TextItem {
    public String wiki;
    public String href;
    public String locale_href;

    @Override
    public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
        this.initializeLocaleText(I18n.tr("More information about this feature", new Object[0]));
        if (this.wiki != null) {
            String url = Config.getUrls().getOSMWiki() + "/wiki/" + this.wiki;
            UrlLabel label = new UrlLabel(url, this.locale_text, 2){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        List<String> pages = Arrays.asList(LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.OSM_WIKI) + Link.this.wiki, Link.this.wiki);
                        HelpAction.displayHelp(pages);
                    } else {
                        super.mouseClicked(e);
                    }
                }
            };
            p.add((Component)label, GBC.eol().insets(0, 10, 0, 0).fill(2));
        } else if (this.href != null || this.locale_href != null) {
            String url = Optional.ofNullable(this.locale_href).orElse(this.href);
            UrlLabel label = new UrlLabel(url, this.locale_text, 2);
            p.add((Component)label, GBC.eol().insets(0, 10, 0, 0).fill(2));
        }
        return false;
    }

    @Override
    protected String fieldsToString() {
        return super.fieldsToString() + (this.wiki != null ? "wiki=" + this.wiki + ", " : "") + (this.href != null ? "href=" + this.href + ", " : "") + (this.locale_href != null ? "locale_href=" + this.locale_href + ", " : "");
    }
}

