/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Modifiers;
import bsh.Name;
import bsh.NameSource;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.This;
import bsh.UtilEvalError;
import bsh.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameSpace
implements Serializable,
BshClassManager.Listener,
NameSource {
    public static final NameSpace JAVACODE = new NameSpace((BshClassManager)null, "Called from compiled Java code.");
    private String nsName;
    private NameSpace parent;
    private Hashtable variables;
    private Hashtable methods;
    protected Hashtable importedClasses;
    private Vector importedPackages;
    private Vector importedCommands;
    private Vector importedObjects;
    private Vector importedStatic;
    private String packageName;
    private transient BshClassManager classManager;
    private This thisReference;
    private Hashtable names;
    SimpleNode callerInfoNode;
    boolean isMethod;
    boolean isClass;
    Class classStatic;
    Object classInstance;
    private transient Hashtable classCache;
    Vector nameSourceListeners;

    void setClassStatic(Class clazz) {
        this.classStatic = clazz;
        this.importStatic(clazz);
    }

    void setClassInstance(Object object) {
        this.classInstance = object;
        this.importObject(object);
    }

    Object getClassInstance() throws UtilEvalError {
        if (this.classInstance != null) {
            return this.classInstance;
        }
        if (this.classStatic != null) {
            throw new UtilEvalError("Can't refer to class instance from static context.");
        }
        throw new InterpreterError("Can't resolve class instance 'this' in: " + this);
    }

    public NameSpace(NameSpace nameSpace, String string) {
        this(nameSpace, null, string);
    }

    public NameSpace(BshClassManager bshClassManager, String string) {
        this(null, bshClassManager, string);
    }

    public NameSpace(NameSpace nameSpace, BshClassManager bshClassManager, String string) {
        this.setName(string);
        this.setParent(nameSpace);
        this.setClassManager(bshClassManager);
        if (bshClassManager != null) {
            bshClassManager.addListener(this);
        }
    }

    public void setName(String string) {
        this.nsName = string;
    }

    public String getName() {
        return this.nsName;
    }

    void setNode(SimpleNode simpleNode) {
        this.callerInfoNode = simpleNode;
    }

    SimpleNode getNode() {
        if (this.callerInfoNode != null) {
            return this.callerInfoNode;
        }
        if (this.parent != null) {
            return this.parent.getNode();
        }
        return null;
    }

    public Object get(String string, Interpreter interpreter) throws UtilEvalError {
        CallStack callStack = new CallStack(this);
        return this.getNameResolver(string).toObject(callStack, interpreter);
    }

    public void setVariable(String string, Object object, boolean bl) throws UtilEvalError {
        boolean bl2 = Interpreter.LOCALSCOPING ? bl : true;
        this.setVariable(string, object, bl, bl2);
    }

    void setLocalVariable(String string, Object object, boolean bl) throws UtilEvalError {
        this.setVariable(string, object, bl, false);
    }

    void setVariable(String string, Object object, boolean bl, boolean bl2) throws UtilEvalError {
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if (object == null) {
            throw new InterpreterError("null variable value");
        }
        Variable variable = this.getVariableImpl(string, bl2);
        if (variable != null) {
            try {
                variable.setValue(object, 1);
            }
            catch (UtilEvalError utilEvalError) {
                throw new UtilEvalError("Variable assignment: " + string + ": " + utilEvalError.getMessage());
            }
        } else {
            if (bl) {
                throw new UtilEvalError("(Strict Java mode) Assignment to undeclared variable: " + string);
            }
            NameSpace nameSpace = this;
            nameSpace.variables.put(string, new Variable(string, object, null));
            this.nameSpaceChanged();
        }
    }

    public void unsetVariable(String string) {
        if (this.variables != null) {
            this.variables.remove(string);
            this.nameSpaceChanged();
        }
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.variables.keys());
    }

    public String[] getMethodNames() {
        if (this.methods == null) {
            return new String[0];
        }
        return this.enumerationToStringArray(this.methods.keys());
    }

    public BshMethod[] getMethods() {
        if (this.methods == null) {
            return new BshMethod[0];
        }
        return this.flattenMethodCollection(this.methods.elements());
    }

    private String[] enumerationToStringArray(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private BshMethod[] flattenMethodCollection(Enumeration enumeration) {
        Object object;
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof BshMethod) {
                vector.addElement(object);
                continue;
            }
            Vector vector2 = (Vector)object;
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        object = new BshMethod[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public NameSpace getParent() {
        return this.parent;
    }

    public This getSuper(Interpreter interpreter) {
        if (this.parent != null) {
            return this.parent.getThis(interpreter);
        }
        return this.getThis(interpreter);
    }

    public This getGlobal(Interpreter interpreter) {
        if (this.parent != null) {
            return this.parent.getGlobal(interpreter);
        }
        return this.getThis(interpreter);
    }

    This getThis(Interpreter interpreter) {
        if (this.thisReference == null) {
            this.thisReference = This.getThis(this, interpreter);
        }
        return this.thisReference;
    }

    public BshClassManager getClassManager() {
        if (this.classManager != null) {
            return this.classManager;
        }
        if (this.parent != null && this.parent != JAVACODE) {
            return this.parent.getClassManager();
        }
        System.out.println("experiment: creating class manager");
        this.classManager = BshClassManager.createClassManager(null);
        return this.classManager;
    }

    void setClassManager(BshClassManager bshClassManager) {
        this.classManager = bshClassManager;
    }

    public void prune() {
        if (this.classManager == null) {
            this.setClassManager(BshClassManager.createClassManager(null));
        }
        this.setParent(null);
    }

    public void setParent(NameSpace nameSpace) {
        this.parent = nameSpace;
        if (nameSpace == null) {
            this.loadDefaultImports();
        }
    }

    public Object getVariable(String string) throws UtilEvalError {
        return this.getVariable(string, true);
    }

    public Object getVariable(String string, boolean bl) throws UtilEvalError {
        Variable variable = this.getVariableImpl(string, bl);
        return this.unwrapVariable(variable);
    }

    protected Variable getVariableImpl(String string, boolean bl) throws UtilEvalError {
        Variable variable = null;
        if (variable == null && this.isClass) {
            variable = this.getImportedVar(string);
        }
        if (variable == null && this.variables != null) {
            variable = (Variable)this.variables.get(string);
        }
        if (variable == null && !this.isClass) {
            variable = this.getImportedVar(string);
        }
        if (bl && variable == null && this.parent != null) {
            variable = this.parent.getVariableImpl(string, bl);
        }
        return variable;
    }

    public Variable[] getDeclaredVariables() {
        if (this.variables == null) {
            return new Variable[0];
        }
        Variable[] variableArray = new Variable[this.variables.size()];
        int n = 0;
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            variableArray[n++] = (Variable)enumeration.nextElement();
        }
        return variableArray;
    }

    protected Object unwrapVariable(Variable variable) throws UtilEvalError {
        return variable == null ? Primitive.VOID : variable.getValue();
    }

    public void setTypedVariable(String string, Class clazz, Object object, boolean bl) throws UtilEvalError {
        Modifiers modifiers = new Modifiers();
        if (bl) {
            modifiers.addModifier(2, "final");
        }
        this.setTypedVariable(string, clazz, object, modifiers);
    }

    public void setTypedVariable(String string, Class clazz, Object object, Modifiers modifiers) throws UtilEvalError {
        Variable variable;
        if (this.variables == null) {
            this.variables = new Hashtable();
        }
        if ((variable = this.getVariableImpl(string, false)) != null && variable.getType() != null) {
            if (variable.getType() != clazz) {
                throw new UtilEvalError("Typed variable: " + string + " was previously declared with type: " + variable.getType());
            }
            variable.setValue(object, 0);
            return;
        }
        this.variables.put(string, new Variable(string, clazz, object, modifiers));
    }

    public void setMethod(String string, BshMethod bshMethod) throws UtilEvalError {
        Object v;
        if (this.methods == null) {
            this.methods = new Hashtable();
        }
        if ((v = this.methods.get(string)) == null) {
            this.methods.put(string, bshMethod);
        } else if (v instanceof BshMethod) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(bshMethod);
            this.methods.put(string, vector);
        } else {
            ((Vector)v).addElement(bshMethod);
        }
    }

    public BshMethod getMethod(String string, Class[] classArray) throws UtilEvalError {
        return this.getMethod(string, classArray, false);
    }

    public BshMethod getMethod(String string, Class[] classArray, boolean bl) throws UtilEvalError {
        Object object = null;
        if (object == null && this.isClass && !bl) {
            object = this.getImportedMethod(string, classArray);
        }
        Object var5_5 = null;
        if (object == null && this.methods != null && (var5_5 = this.methods.get(string)) != null) {
            int n;
            Object[] objectArray;
            Class[][] classArray2;
            if (var5_5 instanceof Vector) {
                classArray2 = var5_5;
                objectArray = new BshMethod[classArray2.size()];
                classArray2.copyInto(objectArray);
            } else {
                objectArray = new BshMethod[]{var5_5};
            }
            classArray2 = new Class[objectArray.length][];
            for (n = 0; n < objectArray.length; ++n) {
                classArray2[n] = ((BshMethod)objectArray[n]).getParameterTypes();
            }
            n = Reflect.findMostSpecificSignature(classArray, classArray2);
            if (n != -1) {
                object = objectArray[n];
            }
        }
        if (object == null && !this.isClass && !bl) {
            object = this.getImportedMethod(string, classArray);
        }
        if (!bl && object == null && this.parent != null) {
            return this.parent.getMethod(string, classArray);
        }
        return object;
    }

    public void importClass(String string) {
        if (this.importedClasses == null) {
            this.importedClasses = new Hashtable();
        }
        this.importedClasses.put(Name.suffix(string, 1), string);
        this.nameSpaceChanged();
    }

    public void importPackage(String string) {
        if (this.importedPackages == null) {
            this.importedPackages = new Vector();
        }
        if (this.importedPackages.contains(string)) {
            this.importedPackages.remove(string);
        }
        this.importedPackages.addElement(string);
        this.nameSpaceChanged();
    }

    public void importCommands(String string) {
        if (this.importedCommands == null) {
            this.importedCommands = new Vector();
        }
        if (!(string = string.replace('.', '/')).startsWith("/")) {
            string = "/" + string;
        }
        if (string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (this.importedCommands.contains(string)) {
            this.importedCommands.remove(string);
        }
        this.importedCommands.addElement(string);
        this.nameSpaceChanged();
    }

    public Object getCommand(String string, Class[] classArray, Interpreter interpreter) throws UtilEvalError {
        if (Interpreter.DEBUG) {
            Interpreter.debug("getCommand: " + string);
        }
        BshClassManager bshClassManager = interpreter.getClassManager();
        if (this.importedCommands != null) {
            for (int i = this.importedCommands.size() - 1; i >= 0; --i) {
                String string2 = (String)this.importedCommands.elementAt(i);
                String string3 = string2.equals("/") ? string2 + string + ".bsh" : string2 + "/" + string + ".bsh";
                Interpreter.debug("searching for script: " + string3);
                InputStream inputStream = bshClassManager.getResourceAsStream(string3);
                if (inputStream != null) {
                    return this.loadScriptedCommand(inputStream, string, classArray, string3, interpreter);
                }
                String string4 = string2.equals("/") ? string : string2.substring(1).replace('/', '.') + "." + string;
                Interpreter.debug("searching for class: " + string4);
                Class clazz = bshClassManager.classForName(string4);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if (this.parent != null) {
            return this.parent.getCommand(string, classArray, interpreter);
        }
        return null;
    }

    protected BshMethod getImportedMethod(String string, Class[] classArray) throws UtilEvalError {
        GenericDeclaration genericDeclaration;
        Object object;
        int n;
        if (this.importedObjects != null) {
            for (n = 0; n < this.importedObjects.size(); ++n) {
                object = this.importedObjects.elementAt(n);
                genericDeclaration = object.getClass();
                Method method = Reflect.resolveJavaMethod(this.getClassManager(), genericDeclaration, string, classArray, false);
                if (method == null) continue;
                return new BshMethod(method, object);
            }
        }
        if (this.importedStatic != null) {
            for (n = 0; n < this.importedStatic.size(); ++n) {
                object = (Class)this.importedStatic.elementAt(n);
                genericDeclaration = Reflect.resolveJavaMethod(this.getClassManager(), object, string, classArray, true);
                if (genericDeclaration == null) continue;
                return new BshMethod((Method)genericDeclaration, null);
            }
        }
        return null;
    }

    protected Variable getImportedVar(String string) throws UtilEvalError {
        AnnotatedElement annotatedElement;
        Object object;
        int n;
        if (this.importedObjects != null) {
            for (n = 0; n < this.importedObjects.size(); ++n) {
                object = this.importedObjects.elementAt(n);
                annotatedElement = object.getClass();
                Field field = Reflect.resolveJavaField(annotatedElement, string, false);
                if (field == null) continue;
                return new Variable(string, field.getType(), new LHS(object, field));
            }
        }
        if (this.importedStatic != null) {
            for (n = 0; n < this.importedStatic.size(); ++n) {
                object = (Class)this.importedStatic.elementAt(n);
                annotatedElement = Reflect.resolveJavaField(object, string, true);
                if (annotatedElement == null) continue;
                return new Variable(string, ((Field)annotatedElement).getType(), new LHS((Field)annotatedElement));
            }
        }
        return null;
    }

    private BshMethod loadScriptedCommand(InputStream inputStream, String string, Class[] classArray, String string2, Interpreter interpreter) throws UtilEvalError {
        try {
            interpreter.eval(new InputStreamReader(inputStream), this, string2);
        }
        catch (EvalError evalError) {
            Interpreter.debug(evalError.toString());
            throw new UtilEvalError("Error loading script: " + evalError.getMessage());
        }
        BshMethod bshMethod = this.getMethod(string, classArray);
        return bshMethod;
    }

    void cacheClass(String string, Class clazz) {
        if (this.classCache == null) {
            this.classCache = new Hashtable();
        }
        this.classCache.put(string, clazz);
    }

    public Class getClass(String string) throws UtilEvalError {
        Class clazz = this.getClassImpl(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClass(string);
        }
        return null;
    }

    private Class getClassImpl(String string) throws UtilEvalError {
        boolean bl;
        Class clazz = null;
        if (this.classCache != null && (clazz = (Class)this.classCache.get(string)) != null) {
            return clazz;
        }
        boolean bl2 = bl = !Name.isCompound(string);
        if (bl) {
            if (clazz == null) {
                clazz = this.getImportedClassImpl(string);
            }
            if (clazz != null) {
                this.cacheClass(string, clazz);
                return clazz;
            }
        }
        if ((clazz = this.classForName(string)) != null) {
            if (bl) {
                this.cacheClass(string, clazz);
            }
            return clazz;
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("getClass(): " + string + " not\tfound in " + this);
        }
        return null;
    }

    private Class getImportedClassImpl(String string) throws UtilEvalError {
        BshClassManager bshClassManager;
        String string2;
        String string3 = null;
        if (this.importedClasses != null) {
            string3 = (String)this.importedClasses.get(string);
        }
        if (string3 != null) {
            Class clazz = this.classForName(string3);
            if (clazz == null) {
                if (Name.isCompound(string3)) {
                    try {
                        clazz = this.getNameResolver(string3).toClass();
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else if (Interpreter.DEBUG) {
                    Interpreter.debug("imported unpackaged name not found:" + string3);
                }
                if (clazz != null) {
                    this.getClassManager().cacheClassInfo(string3, clazz);
                    return clazz;
                }
            } else {
                return clazz;
            }
            return null;
        }
        if (this.importedPackages != null) {
            for (int i = this.importedPackages.size() - 1; i >= 0; --i) {
                string2 = (String)this.importedPackages.elementAt(i) + "." + string;
                Class clazz = this.classForName(string2);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((bshClassManager = this.getClassManager()).hasSuperImport() && (string2 = bshClassManager.getClassNameByUnqName(string)) != null) {
            return this.classForName(string2);
        }
        return null;
    }

    private Class classForName(String string) {
        return this.getClassManager().classForName(string);
    }

    public String[] getAllNames() {
        Vector vector = new Vector();
        this.getAllNamesAux(vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void getAllNamesAux(Vector vector) {
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.methods.keys();
        while (enumeration2.hasMoreElements()) {
            vector.addElement(enumeration2.nextElement());
        }
        if (this.parent != null) {
            this.parent.getAllNamesAux(vector);
        }
    }

    public void addNameSourceListener(NameSource.Listener listener) {
        if (this.nameSourceListeners == null) {
            this.nameSourceListeners = new Vector();
        }
        this.nameSourceListeners.addElement(listener);
    }

    public void doSuperImport() throws UtilEvalError {
        this.getClassManager().doSuperImport();
    }

    public String toString() {
        return "NameSpace: " + (this.nsName == null ? super.toString() : this.nsName + " (" + super.toString() + ")") + (this.isClass ? " (isClass) " : "") + (this.isMethod ? " (method) " : "") + (this.classStatic != null ? " (class static) " : "") + (this.classInstance != null ? " (class instance) " : "");
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.names = null;
        objectOutputStream.defaultWriteObject();
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invokeMethod(string, objectArray, interpreter, null, null);
    }

    public Object invokeMethod(String string, Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        return this.getThis(interpreter).invokeMethod(string, objectArray, interpreter, callStack, simpleNode, false);
    }

    public void classLoaderChanged() {
        this.nameSpaceChanged();
    }

    public void nameSpaceChanged() {
        this.classCache = null;
        this.names = null;
    }

    public void loadDefaultImports() {
        this.importClass("bsh.EvalError");
        this.importClass("bsh.Interpreter");
        this.importPackage("javax.swing.event");
        this.importPackage("javax.swing");
        this.importPackage("java.awt.event");
        this.importPackage("java.awt");
        this.importPackage("java.net");
        this.importPackage("java.util");
        this.importPackage("java.io");
        this.importPackage("java.lang");
        this.importCommands("/bsh/commands");
    }

    Name getNameResolver(String string) {
        Name name;
        if (this.names == null) {
            this.names = new Hashtable();
        }
        if ((name = (Name)this.names.get(string)) == null) {
            name = new Name(this, string);
            this.names.put(string, name);
        }
        return name;
    }

    public int getInvocationLine() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getLineNumber();
        }
        return -1;
    }

    public String getInvocationText() {
        SimpleNode simpleNode = this.getNode();
        if (simpleNode != null) {
            return simpleNode.getText();
        }
        return "<invoked from Java code>";
    }

    public static Class identifierToClass(ClassIdentifier classIdentifier) {
        return classIdentifier.getTargetClass();
    }

    public void clear() {
        this.variables = null;
        this.methods = null;
        this.importedClasses = null;
        this.importedPackages = null;
        this.importedCommands = null;
        this.importedObjects = null;
        if (this.parent == null) {
            this.loadDefaultImports();
        }
        this.classCache = null;
        this.names = null;
    }

    public void importObject(Object object) {
        if (this.importedObjects == null) {
            this.importedObjects = new Vector();
        }
        if (this.importedObjects.contains(object)) {
            this.importedObjects.remove(object);
        }
        this.importedObjects.addElement(object);
        this.nameSpaceChanged();
    }

    public void importStatic(Class clazz) {
        if (this.importedStatic == null) {
            this.importedStatic = new Vector();
        }
        if (this.importedStatic.contains(clazz)) {
            this.importedStatic.remove(clazz);
        }
        this.importedStatic.addElement(clazz);
        this.nameSpaceChanged();
    }

    void setPackage(String string) {
        this.packageName = string;
    }

    String getPackage() {
        if (this.packageName != null) {
            return this.packageName;
        }
        if (this.parent != null) {
            return this.parent.getPackage();
        }
        return null;
    }

    static {
        NameSpace.JAVACODE.isMethod = true;
    }
}

