/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.replacestring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.replacestring.Messages;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringData;
import org.pentaho.di.trans.steps.replacestring.ReplaceStringMeta;

public class ReplaceString
extends BaseStep
implements StepInterface {
    private ReplaceStringMeta meta;
    private ReplaceStringData data;

    public ReplaceString(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public static String replaceString(String originalString, Pattern pattern, String replaceByString) {
        if (originalString == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(originalString);
        if (replaceByString == null) {
            if (matcher.matches()) {
                return null;
            }
            return originalString;
        }
        return matcher.replaceAll(replaceByString);
    }

    private Pattern buildPattern(boolean literalParsing, boolean caseSensitive, boolean wholeWord, String patternString) {
        int flags = 0;
        if (literalParsing) {
            flags |= 0x10;
        }
        if (!caseSensitive) {
            flags |= 2;
        }
        if (wholeWord) {
            patternString = "\\b" + patternString + "\\b";
        }
        return Pattern.compile(patternString, flags);
    }

    private synchronized Object[] getOneRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] rowData = RowDataUtil.resizeArray((Object[])row, (int)this.data.outputRowMeta.size());
        int length = this.meta.getFieldInStream().length;
        for (int i = 0; i < length; ++i) {
            String value = ReplaceString.replaceString(this.getInputRowMeta().getString(row, this.data.inStreamNrs[i]), this.data.patterns[i], this.data.replaceByString[i]);
            if (Const.isEmpty((String)this.data.outStreamNrs[i])) {
                rowData[this.data.inStreamNrs[i]] = value;
                continue;
            }
            rowData[this.data.inputFieldsNr + i] = value;
        }
        return rowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block9: {
            this.meta = (ReplaceStringMeta)smi;
            this.data = (ReplaceStringData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputFieldsNr = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                int numFields = this.meta.getFieldInStream().length;
                this.data.inStreamNrs = new int[numFields];
                this.data.outStreamNrs = new String[numFields];
                this.data.patterns = new Pattern[numFields];
                this.data.replaceByString = new String[numFields];
                for (int i = 0; i < numFields; ++i) {
                    this.data.inStreamNrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldInStream()[i]);
                    if (this.data.inStreamNrs[i] < 0) {
                        throw new KettleStepException(Messages.getString("ReplaceString.Exception.FieldRequired", this.meta.getFieldInStream()[i]));
                    }
                    if (this.getInputRowMeta().getValueMeta(this.data.inStreamNrs[i]).getType() != 2) {
                        throw new KettleStepException(Messages.getString("ReplaceString.Exception.FieldTypeNotString", this.meta.getFieldInStream()[i]));
                    }
                    this.data.outStreamNrs[i] = this.environmentSubstitute(this.meta.getFieldOutStream()[i]);
                    this.data.patterns[i] = this.buildPattern(this.meta.getUseRegEx()[i] != 1, this.meta.getCaseSensitive()[i] == 1, this.meta.getWholeWord()[i] == 1, this.environmentSubstitute(this.meta.getReplaceString()[i]));
                    this.data.replaceByString[i] = this.environmentSubstitute(this.meta.getReplaceByString()[i]);
                }
            }
            try {
                Object[] output = this.getOneRow(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("ReplaceString.Log.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("ReplaceString.Log.ErrorInStep", e.getMessage()));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block9;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ReplaceString001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ReplaceStringMeta)smi;
        this.data = (ReplaceStringData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ReplaceStringMeta)smi;
        this.data = (ReplaceStringData)sdi;
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

