/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.writer.visitor;

import java.util.List;
import org.jd.core.v1.api.printer.Printer;
import org.jd.core.v1.model.token.AbstractNopTokenVisitor;
import org.jd.core.v1.model.token.BooleanConstantToken;
import org.jd.core.v1.model.token.CharacterConstantToken;
import org.jd.core.v1.model.token.DeclarationToken;
import org.jd.core.v1.model.token.EndBlockToken;
import org.jd.core.v1.model.token.EndMarkerToken;
import org.jd.core.v1.model.token.KeywordToken;
import org.jd.core.v1.model.token.LineNumberToken;
import org.jd.core.v1.model.token.NewLineToken;
import org.jd.core.v1.model.token.NumericConstantToken;
import org.jd.core.v1.model.token.ReferenceToken;
import org.jd.core.v1.model.token.StartBlockToken;
import org.jd.core.v1.model.token.StartMarkerToken;
import org.jd.core.v1.model.token.StringConstantToken;
import org.jd.core.v1.model.token.TextToken;
import org.jd.core.v1.model.token.Token;
import org.jd.core.v1.model.token.TokenVisitor;

public class PrintTokenVisitor
implements TokenVisitor {
    public static int UNKNOWN_LINE_NUMBER = 0;
    protected SearchLineNumberVisitor searchLineNumberVisitor = new SearchLineNumberVisitor();
    protected Printer printer;
    protected List<Token> tokens;
    protected int index;
    protected int newLineCount;

    public void start(Printer printer, List<Token> tokens) {
        this.printer = printer;
        this.tokens = tokens;
        this.index = 0;
        this.newLineCount = 0;
        printer.startLine(this.searchLineNumber());
    }

    public void end() {
        this.printer.endLine();
    }

    @Override
    public void visit(BooleanConstantToken token) {
        this.prepareNewLine();
        this.printer.printKeyword(token.getValue() ? "true" : "false");
        ++this.index;
    }

    @Override
    public void visit(CharacterConstantToken token) {
        this.prepareNewLine();
        this.printer.printStringConstant('\'' + token.getCharacter() + '\'', token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(DeclarationToken token) {
        this.prepareNewLine();
        this.printer.printDeclaration(token.getType(), token.getInternalTypeName(), token.getName(), token.getDescriptor());
        ++this.index;
    }

    @Override
    public void visit(StartBlockToken token) {
        this.prepareNewLine();
        this.printer.printText(token.getText());
        this.printer.indent();
        if (token == StartBlockToken.START_RESOURCES_BLOCK) {
            this.printer.indent();
        }
        ++this.index;
    }

    @Override
    public void visit(EndBlockToken token) {
        this.printer.unindent();
        if (token == EndBlockToken.END_RESOURCES_BLOCK) {
            this.printer.unindent();
        }
        this.prepareNewLine();
        this.printer.printText(token.getText());
        ++this.index;
    }

    @Override
    public void visit(StartMarkerToken token) {
        this.prepareNewLine();
        this.printer.startMarker(token.getType());
        ++this.index;
    }

    @Override
    public void visit(EndMarkerToken token) {
        this.prepareNewLine();
        this.printer.endMarker(token.getType());
        ++this.index;
    }

    @Override
    public void visit(NewLineToken token) {
        this.newLineCount += token.getCount();
        ++this.index;
    }

    @Override
    public void visit(KeywordToken token) {
        this.prepareNewLine();
        this.printer.printKeyword(token.getKeyword());
        ++this.index;
    }

    @Override
    public void visit(LineNumberToken token) {
        ++this.index;
    }

    @Override
    public void visit(NumericConstantToken token) {
        this.prepareNewLine();
        this.printer.printNumericConstant(token.getText());
        ++this.index;
    }

    @Override
    public void visit(ReferenceToken token) {
        this.prepareNewLine();
        this.printer.printReference(token.getType(), token.getInternalTypeName(), token.getName(), token.getDescriptor(), token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(StringConstantToken token) {
        this.prepareNewLine();
        this.printer.printStringConstant('\"' + token.getText() + '\"', token.getOwnerInternalName());
        ++this.index;
    }

    @Override
    public void visit(TextToken token) {
        this.prepareNewLine();
        this.printer.printText(token.getText());
        ++this.index;
    }

    protected void prepareNewLine() {
        if (this.newLineCount > 0) {
            this.printer.endLine();
            if (this.newLineCount > 2) {
                this.printer.extraLine(this.newLineCount - 2);
                this.newLineCount = 2;
            }
            if (this.newLineCount > 1) {
                this.printer.startLine(UNKNOWN_LINE_NUMBER);
                this.printer.endLine();
            }
            this.printer.startLine(this.searchLineNumber());
            this.newLineCount = 0;
        }
    }

    protected int searchLineNumber() {
        this.searchLineNumberVisitor.reset();
        for (int i = this.index; i >= 0; --i) {
            this.tokens.get(i).accept(this.searchLineNumberVisitor);
            if (this.searchLineNumberVisitor.lineNumber != UNKNOWN_LINE_NUMBER) {
                return this.searchLineNumberVisitor.lineNumber;
            }
            if (this.searchLineNumberVisitor.newLineCounter > 0) break;
        }
        this.searchLineNumberVisitor.reset();
        int size = this.tokens.size();
        for (int i = this.index; i < size; ++i) {
            this.tokens.get(i).accept(this.searchLineNumberVisitor);
            if (this.searchLineNumberVisitor.lineNumber != UNKNOWN_LINE_NUMBER) {
                return this.searchLineNumberVisitor.lineNumber;
            }
            if (this.searchLineNumberVisitor.newLineCounter > 0) break;
        }
        return UNKNOWN_LINE_NUMBER;
    }

    protected static class SearchLineNumberVisitor
    extends AbstractNopTokenVisitor {
        public int lineNumber;
        public int newLineCounter;

        protected SearchLineNumberVisitor() {
        }

        public void reset() {
            this.lineNumber = UNKNOWN_LINE_NUMBER;
            this.newLineCounter = 0;
        }

        @Override
        public void visit(LineNumberToken token) {
            this.lineNumber = token.getLineNumber();
        }

        @Override
        public void visit(NewLineToken token) {
            ++this.newLineCounter;
        }
    }
}

