/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.platform;

public class PlatformService {
    protected static final PlatformService PLATFORM_SERVICE = new PlatformService();
    protected OS os;

    protected PlatformService() {
        String osName = System.getProperty("os.name").toLowerCase();
        this.os = osName.contains("windows") ? OS.Windows : (osName.contains("mac os") ? OS.MacOSX : OS.Linux);
    }

    public static PlatformService getInstance() {
        return PLATFORM_SERVICE;
    }

    public OS getOs() {
        return this.os;
    }

    public boolean isLinux() {
        return this.os == OS.Linux;
    }

    public boolean isMac() {
        return this.os == OS.MacOSX;
    }

    public boolean isWindows() {
        return this.os == OS.Windows;
    }

    public static enum OS {
        Linux,
        MacOSX,
        Windows;

    }
}

