/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) + u64vec2(10ul, 12ul)) => u64vec2(20ul, 24ul)
 * (u64vec2(10ul, 12ul) + u64vec2(42ul, 48ul)) => u64vec2(52ul, 60ul)
 * (u64vec2(42ul, 48ul) + u64vec2(10ul, 12ul)) => u64vec2(52ul, 60ul)
 * (u64vec2(42ul, 48ul) + u64vec2(42ul, 48ul)) => u64vec2(84ul, 96ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) + u64vec2(10ul, 12ul)), u64vec2(20ul, 24ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) + u64vec2(42ul, 48ul)), u64vec2(52ul, 60ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(42ul, 48ul) + u64vec2(10ul, 12ul)), u64vec2(52ul, 60ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(42ul, 48ul) + u64vec2(42ul, 48ul)), u64vec2(84ul, 96ul))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
