/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html.charsetdetector.charsets;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.NotImplementedException;

public class XUserDefinedCharset
extends Charset {
    public XUserDefinedCharset() {
        super("x-user-defined", null);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.equals(StandardCharsets.US_ASCII);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoder(this, 1.0f, 1.0f){

            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                while (in.hasRemaining()) {
                    if (!out.hasRemaining()) {
                        return CoderResult.OVERFLOW;
                    }
                    int b = in.get();
                    out.append((char)(b >= 0 ? b : 63232 + (b & 0xFF)));
                }
                return CoderResult.UNDERFLOW;
            }
        };
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new NotImplementedException("Encoding to x-user-defined is not implemented");
    }
}

