/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.InflaterInputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CdcrUpdateLog;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.PropertiesOutputStream;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFetcher {
    private static final int _100K = 100000;
    public static final String INDEX_PROPERTIES = "index.properties";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String leaderUrl;
    final ReplicationHandler replicationHandler;
    private volatile Date replicationStartTimeStamp;
    private RTimer replicationTimer;
    private final SolrCore solrCore;
    private volatile List<Map<String, Object>> filesToDownload;
    private volatile List<Map<String, Object>> confFilesToDownload;
    private volatile List<Map<String, Object>> tlogFilesToDownload;
    private volatile List<Map<String, Object>> filesDownloaded;
    private volatile List<Map<String, Object>> confFilesDownloaded;
    private volatile List<Map<String, Object>> tlogFilesDownloaded;
    private volatile Map<String, Object> currentFile;
    private volatile DirectoryFileFetcher dirFileFetcher;
    private volatile LocalFsFileFetcher localFileFetcher;
    private volatile ExecutorService fsyncService;
    private volatile boolean stop = false;
    private boolean useInternalCompression = false;
    private boolean useExternalCompression = false;
    boolean fetchFromLeader = false;
    private final HttpClient myHttpClient;
    private Integer connTimeout;
    private Integer soTimeout;
    private boolean downloadTlogFiles = false;
    private boolean skipCommitOnLeaderVersionZero = true;
    private boolean clearLocalIndexFirst = false;
    private static final String INTERRUPT_RESPONSE_MESSAGE = "Interrupted while waiting for modify lock";
    private volatile Exception fsyncException;
    static BooleanSupplier testWait = () -> true;
    static Function<String, Long> usableDiskSpaceProvider = dir -> IndexFetcher.getUsableSpace(dir);
    private final Map<String, ReplicationHandler.FileInfo> confFileInfoCache = new HashMap<String, ReplicationHandler.FileInfo>();
    private static final int MAX_RETRIES = 5;
    private static final int NO_CONTENT = 1;
    private static final int ERR = 2;
    public static final String REPLICATION_PROPERTIES = "replication.properties";
    static final String INDEX_REPLICATED_AT = "indexReplicatedAt";
    static final String TIMES_INDEX_REPLICATED = "timesIndexReplicated";
    static final String CLEARED_LOCAL_IDX = "clearedLocalIndexFirst";
    static final String CONF_FILES_REPLICATED = "confFilesReplicated";
    static final String CONF_FILES_REPLICATED_AT = "confFilesReplicatedAt";
    static final String TIMES_CONFIG_REPLICATED = "timesConfigReplicated";
    static final String LAST_CYCLE_BYTES_DOWNLOADED = "lastCycleBytesDownloaded";
    static final String TIMES_FAILED = "timesFailed";
    static final String REPLICATION_FAILED_AT = "replicationFailedAt";
    static final String PREVIOUS_CYCLE_TIME_TAKEN = "previousCycleTimeInSeconds";
    static final String INDEX_REPLICATED_AT_LIST = "indexReplicatedAtList";
    static final String REPLICATION_FAILED_AT_LIST = "replicationFailedAtList";

    private static HttpClient createHttpClient(SolrCore core, String httpBasicAuthUser, String httpBasicAuthPassword, boolean useCompression) {
        ModifiableSolrParams httpClientParams = new ModifiableSolrParams();
        httpClientParams.set("httpBasicAuthUser", new String[]{httpBasicAuthUser});
        httpClientParams.set("httpBasicAuthPassword", new String[]{httpBasicAuthPassword});
        httpClientParams.set("allowCompression", useCompression);
        return HttpClientUtil.createClient((SolrParams)httpClientParams, (PoolingHttpClientConnectionManager)core.getCoreContainer().getUpdateShardHandler().getRecoveryOnlyConnectionManager(), (boolean)true);
    }

    public IndexFetcher(NamedList initArgs, ReplicationHandler handler, SolrCore sc) {
        String leaderUrl;
        Object skipCommitOnLeaderVersionZero;
        this.solrCore = sc;
        Object fetchFromLeader = initArgs.get("fetchFromLeader");
        if (fetchFromLeader != null && fetchFromLeader instanceof Boolean) {
            this.fetchFromLeader = (Boolean)fetchFromLeader;
        }
        if ((skipCommitOnLeaderVersionZero = ReplicationHandler.getObjectWithBackwardCompatibility(initArgs, "skipCommitOnLeaderVersionZero", "skipCommitOnMasterVersionZero")) != null && skipCommitOnLeaderVersionZero instanceof Boolean) {
            this.skipCommitOnLeaderVersionZero = (Boolean)skipCommitOnLeaderVersionZero;
        }
        if ((leaderUrl = (String)ReplicationHandler.getObjectWithBackwardCompatibility(initArgs, "leaderUrl", "masterUrl")) == null && !this.fetchFromLeader) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'leaderUrl' is required for a follower");
        }
        if (leaderUrl != null && leaderUrl.endsWith("/replication")) {
            leaderUrl = leaderUrl.substring(0, leaderUrl.length() - 12);
            log.warn("'leaderUrl' must be specified without the {} suffix", (Object)"/replication");
        }
        this.setLeaderUrl(leaderUrl);
        this.replicationHandler = handler;
        String compress = (String)initArgs.get("compression");
        this.useInternalCompression = "internal".equals(compress);
        this.useExternalCompression = "external".equals(compress);
        this.connTimeout = this.getParameter(initArgs, "connTimeout", 30000, null);
        this.soTimeout = Integer.getInteger("solr.indexfetcher.sotimeout", -1);
        if (this.soTimeout == -1) {
            this.soTimeout = this.getParameter(initArgs, "socketTimeout", 120000, null);
        }
        if (initArgs.getBooleanArg("tlogFiles") != null) {
            this.downloadTlogFiles = initArgs.getBooleanArg("tlogFiles");
        }
        String httpBasicAuthUser = (String)initArgs.get("httpBasicAuthUser");
        String httpBasicAuthPassword = (String)initArgs.get("httpBasicAuthPassword");
        this.myHttpClient = IndexFetcher.createHttpClient(this.solrCore, httpBasicAuthUser, httpBasicAuthPassword, this.useExternalCompression);
    }

    private void setLeaderUrl(String leaderUrl) {
        ShardHandlerFactory shardHandlerFactory;
        if (leaderUrl != null && (shardHandlerFactory = this.solrCore.getCoreContainer().getShardHandlerFactory()) instanceof HttpShardHandlerFactory) {
            ZkController zkController = this.solrCore.getCoreContainer().getZkController();
            ClusterState clusterState = zkController == null ? null : zkController.getClusterState();
            try {
                ((HttpShardHandlerFactory)shardHandlerFactory).getWhitelistHostChecker().checkWhitelist(clusterState, null, Collections.singletonList(leaderUrl));
            }
            catch (SolrException e) {
                if (e.code() == SolrException.ErrorCode.BAD_REQUEST.code) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid URL syntax in 'leaderUrl' with value '" + leaderUrl + "'", (Throwable)e);
                }
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "The 'leaderUrl' parameter value '" + leaderUrl + "' is not in the '" + "shardsWhitelist" + "'." + " set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks");
            }
        }
        this.leaderUrl = leaderUrl;
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue, StringBuilder sb) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            T t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NamedList getLatestVersion() throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"indexversion"});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.leaderUrl).withHttpClient(this.myHttpClient)).withConnectionTimeout(this.connTimeout.intValue())).withSocketTimeout(this.soTimeout.intValue())).build();){
            NamedList namedList = client.request((SolrRequest)req);
            return namedList;
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private void fetchFileList(long gen) throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"filelist"});
        params.set("tlogFiles", this.downloadTlogFiles);
        params.set("generation", new String[]{String.valueOf(gen)});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.leaderUrl).withHttpClient(this.myHttpClient)).withConnectionTimeout(this.connTimeout.intValue())).withSocketTimeout(this.soTimeout.intValue())).build();){
            NamedList response = client.request((SolrRequest)req);
            List files = (List)response.get("filelist");
            if (files != null) {
                this.filesToDownload = Collections.synchronizedList(files);
            } else {
                this.filesToDownload = Collections.emptyList();
                log.error("No files to download for index generation: {}", (Object)gen);
            }
            files = (List)response.get("confFiles");
            if (files != null) {
                this.confFilesToDownload = Collections.synchronizedList(files);
            }
            if ((files = (List)response.get("tlogFiles")) != null) {
                this.tlogFilesToDownload = Collections.synchronizedList(files);
            }
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    IndexFetchResult fetchLatestIndex(boolean forceReplication) throws IOException, InterruptedException {
        return this.fetchLatestIndex(forceReplication, false);
    }

    /*
     * Exception decompiling
     */
    IndexFetchResult fetchLatestIndex(boolean forceReplication, boolean forceCoreReload) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Replica getLeaderReplica() throws InterruptedException {
        ZkController zkController = this.solrCore.getCoreContainer().getZkController();
        CloudDescriptor cd = this.solrCore.getCoreDescriptor().getCloudDescriptor();
        Replica leaderReplica = zkController.getZkStateReader().getLeaderRetry(cd.getCollectionName(), cd.getShardId());
        return leaderReplica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanup(SolrCore core, Directory tmpIndexDir, Directory indexDir, boolean deleteTmpIdxDir, File tmpTlogDir, boolean successfulInstall) throws IOException {
        try {
            if (!successfulInstall) {
                try {
                    this.logReplicationTimeAndConfFiles(null, successfulInstall);
                }
                catch (Exception e) {
                    log.warn("Could not log failed replication details", (Throwable)e);
                }
            }
            if (core.getCoreContainer().isZooKeeperAware()) {
                core.getUpdateHandler().getSolrCoreState().setLastReplicateIndexSuccess(successfulInstall);
            }
            this.tlogFilesDownloaded = null;
            this.tlogFilesToDownload = null;
            this.confFilesToDownload = null;
            this.confFilesDownloaded = null;
            this.filesDownloaded = null;
            this.filesToDownload = null;
            this.markReplicationStop();
            this.dirFileFetcher = null;
            this.localFileFetcher = null;
            if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                this.fsyncService.shutdown();
            }
            this.fsyncService = null;
            this.stop = false;
            this.fsyncException = null;
            return;
        }
        finally {
            try {
                if (tmpIndexDir != null && deleteTmpIdxDir) {
                    core.getDirectoryFactory().doneWithDirectory(tmpIndexDir);
                    core.getDirectoryFactory().remove(tmpIndexDir);
                }
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (Throwable)e);
            }
            finally {
                try {
                    if (tmpIndexDir != null) {
                        core.getDirectoryFactory().release(tmpIndexDir);
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
                try {
                    if (indexDir != null) {
                        core.getDirectoryFactory().release(indexDir);
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
                try {
                    if (tmpTlogDir != null) {
                        IndexFetcher.delTree(tmpTlogDir);
                    }
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
            }
        }
    }

    private boolean hasUnusedFiles(Directory indexDir, IndexCommit commit) throws IOException {
        String[] allFiles;
        String segmentsFileName = commit.getSegmentsFileName();
        SegmentInfos infos = SegmentInfos.readCommit((Directory)indexDir, (String)segmentsFileName);
        HashSet currentFiles = new HashSet(infos.files(true));
        for (String file : allFiles = indexDir.listAll()) {
            if (file.equals(segmentsFileName) || currentFiles.contains(file) || file.endsWith(".lock")) continue;
            log.info("Found unused file: {}", (Object)file);
            return true;
        }
        return false;
    }

    private void terminateAndWaitFsyncService() throws Exception {
        if (this.fsyncService.isTerminated()) {
            return;
        }
        this.fsyncService.shutdown();
        this.fsyncService.awaitTermination(3600L, TimeUnit.SECONDS);
        Exception fsyncExceptionCopy = this.fsyncException;
        if (fsyncExceptionCopy != null) {
            throw fsyncExceptionCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressForbidden(reason="Need currentTimeMillis for debugging/stats")
    private void logReplicationTimeAndConfFiles(Collection<Map<String, Object>> modifiedConfFiles, boolean successfulInstall) throws IOException {
        ArrayList<String> confFiles = new ArrayList<String>();
        if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
            for (Map<String, Object> map1 : modifiedConfFiles) {
                confFiles.add((String)map1.get("name"));
            }
        }
        Properties props = this.replicationHandler.loadReplicationProperties();
        long replicationTime = System.currentTimeMillis();
        long replicationTimeTaken = this.getReplicationTimeElapsed();
        Directory dir = null;
        try {
            dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.solrCore.getSolrConfig().indexConfig.lockType);
            int indexCount = 1;
            int confFilesCount = 1;
            if (props.containsKey(TIMES_INDEX_REPLICATED)) {
                indexCount = Integer.parseInt(props.getProperty(TIMES_INDEX_REPLICATED)) + 1;
            }
            StringBuilder sb = this.readToStringBuilder(replicationTime, props.getProperty(INDEX_REPLICATED_AT_LIST));
            props.setProperty(INDEX_REPLICATED_AT_LIST, sb.toString());
            props.setProperty(INDEX_REPLICATED_AT, String.valueOf(replicationTime));
            props.setProperty(PREVIOUS_CYCLE_TIME_TAKEN, String.valueOf(replicationTimeTaken));
            props.setProperty(TIMES_INDEX_REPLICATED, String.valueOf(indexCount));
            if (this.clearLocalIndexFirst) {
                props.setProperty(CLEARED_LOCAL_IDX, "true");
            }
            if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
                props.setProperty(CONF_FILES_REPLICATED, ((Object)confFiles).toString());
                props.setProperty(CONF_FILES_REPLICATED_AT, String.valueOf(replicationTime));
                if (props.containsKey(TIMES_CONFIG_REPLICATED)) {
                    confFilesCount = Integer.parseInt(props.getProperty(TIMES_CONFIG_REPLICATED)) + 1;
                }
                props.setProperty(TIMES_CONFIG_REPLICATED, String.valueOf(confFilesCount));
            }
            props.setProperty(LAST_CYCLE_BYTES_DOWNLOADED, String.valueOf(this.getTotalBytesDownloaded()));
            if (!successfulInstall) {
                int numFailures = 1;
                if (props.containsKey(TIMES_FAILED)) {
                    numFailures = Integer.parseInt(props.getProperty(TIMES_FAILED)) + 1;
                }
                props.setProperty(TIMES_FAILED, String.valueOf(numFailures));
                props.setProperty(REPLICATION_FAILED_AT, String.valueOf(replicationTime));
                sb = this.readToStringBuilder(replicationTime, props.getProperty(REPLICATION_FAILED_AT_LIST));
                props.setProperty(REPLICATION_FAILED_AT_LIST, sb.toString());
            }
            String tmpFileName = "replication.properties." + System.nanoTime();
            IndexOutput out = dir.createOutput(tmpFileName, DirectoryFactory.IOCONTEXT_NO_CACHE);
            OutputStreamWriter outFile = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), StandardCharsets.UTF_8);
            try {
                props.store(outFile, "Replication details");
                dir.sync(Collections.singleton(tmpFileName));
            }
            finally {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)outFile);
            }
            this.solrCore.getDirectoryFactory().renameWithOverwrite(dir, tmpFileName, REPLICATION_PROPERTIES);
            if (dir == null) return;
        }
        catch (Exception e) {
            try {
                log.warn("Exception while updating statistics", (Throwable)e);
                if (dir == null) return;
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                this.solrCore.getDirectoryFactory().release(dir);
                throw throwable;
            }
            this.solrCore.getDirectoryFactory().release(dir);
            return;
        }
        this.solrCore.getDirectoryFactory().release(dir);
        return;
    }

    long getTotalBytesDownloaded() {
        long bytesDownloaded = 0L;
        for (Map<String, Object> file : this.getFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        for (Map<String, Object> file : this.getConfFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        Map<String, Object> currentFile = this.getCurrentFile();
        if (currentFile != null && currentFile.containsKey("bytesDownloaded")) {
            bytesDownloaded += ((Long)currentFile.get("bytesDownloaded")).longValue();
        }
        return bytesDownloaded;
    }

    private StringBuilder readToStringBuilder(long replicationTime, String str) {
        StringBuilder sb = new StringBuilder();
        ArrayList l = new ArrayList();
        if (str != null && str.length() != 0) {
            String[] ss = str.split(",");
            Collections.addAll(l, ss);
        }
        sb.append(replicationTime);
        if (!l.isEmpty()) {
            for (int i = 0; (i < l.size() || i < 9) && i != l.size() && i != 9; ++i) {
                String s = (String)l.get(i);
                sb.append(",").append(s);
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSearcherAndUpdateCommitPoint() throws IOException {
        IndexCommit commitPoint;
        RefCounted<SolrIndexSearcher> searcher = null;
        SolrCore core = this.solrCore.getCoreContainer().getCore(this.solrCore.getName());
        try {
            Future[] waitSearcher = new Future[1];
            searcher = core.getSearcher(true, true, waitSearcher, true);
            if (waitSearcher[0] != null) {
                try {
                    waitSearcher[0].get();
                }
                catch (InterruptedException | ExecutionException e) {
                    SolrException.log((Logger)log, (Throwable)e);
                }
            }
            commitPoint = searcher.get().getIndexReader().getIndexCommit();
        }
        finally {
            if (searcher != null) {
                searcher.decref();
            }
            core.close();
        }
        this.replicationHandler.indexCommitPoint = commitPoint;
    }

    private void reloadCore() {
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try {
                this.solrCore.getCoreContainer().reload(this.solrCore.getName(), this.solrCore.uniqueId);
            }
            catch (Exception e) {
                log.error("Could not reload core ", (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        }).start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for core reload to finish", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadConfFiles(List<Map<String, Object>> confFilesToDownload, long latestGeneration) throws Exception {
        log.info("Starting download of configuration files from leader: {}", confFilesToDownload);
        this.confFilesDownloaded = Collections.synchronizedList(new ArrayList());
        File tmpconfDir = new File(this.solrCore.getResourceLoader().getConfigDir(), "conf." + this.getDateAsStr(new Date()));
        try {
            boolean status = tmpconfDir.mkdirs();
            if (!status) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create temporary config folder: " + tmpconfDir.getName());
            }
            for (Map<String, Object> file : confFilesToDownload) {
                String saveAs = (String)(file.get("alias") == null ? file.get("name") : file.get("alias"));
                this.localFileFetcher = new LocalFsFileFetcher(tmpconfDir, file, saveAs, "cf", latestGeneration);
                this.currentFile = file;
                this.localFileFetcher.fetchFile();
                this.confFilesDownloaded.add(new HashMap<String, Object>(file));
            }
            this.terminateAndWaitFsyncService();
            this.copyTmpConfFiles2Conf(tmpconfDir);
        }
        finally {
            IndexFetcher.delTree(tmpconfDir);
        }
    }

    private long downloadTlogFiles(File tmpTlogDir, long latestGeneration) throws Exception {
        log.info("Starting download of tlog files from leader: {}", this.tlogFilesToDownload);
        this.tlogFilesDownloaded = Collections.synchronizedList(new ArrayList());
        long bytesDownloaded = 0L;
        boolean status = tmpTlogDir.mkdirs();
        if (!status) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create temporary tlog folder: " + tmpTlogDir.getName());
        }
        for (Map<String, Object> file : this.tlogFilesToDownload) {
            String saveAs = (String)(file.get("alias") == null ? file.get("name") : file.get("alias"));
            this.localFileFetcher = new LocalFsFileFetcher(tmpTlogDir, file, saveAs, "tlogFile", latestGeneration);
            this.currentFile = file;
            this.localFileFetcher.fetchFile();
            bytesDownloaded += this.localFileFetcher.getBytesDownloaded();
            this.tlogFilesDownloaded.add(new HashMap<String, Object>(file));
        }
        return bytesDownloaded;
    }

    private long downloadIndexFiles(boolean downloadCompleteIndex, Directory indexDir, Directory tmpIndexDir, String indexDirPath, String tmpIndexDirPath, long latestGeneration) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Download files to dir: {}", Arrays.asList(indexDir.listAll()));
        }
        long bytesDownloaded = 0L;
        long bytesSkippedCopying = 0L;
        boolean doDifferentialCopy = (indexDir instanceof FSDirectory || indexDir instanceof FilterDirectory && FilterDirectory.unwrap((Directory)indexDir) instanceof FSDirectory) && (tmpIndexDir instanceof FSDirectory || tmpIndexDir instanceof FilterDirectory && FilterDirectory.unwrap((Directory)tmpIndexDir) instanceof FSDirectory);
        long totalSpaceRequired = 0L;
        for (Map<String, Object> file : this.filesToDownload) {
            long size = (Long)file.get("size");
            totalSpaceRequired += size;
        }
        if (log.isInfoEnabled()) {
            log.info("tmpIndexDir_type  : {} , {}", tmpIndexDir.getClass(), (Object)FilterDirectory.unwrap((Directory)tmpIndexDir));
        }
        long usableSpace = usableDiskSpaceProvider.apply(tmpIndexDirPath);
        if (this.getApproxTotalSpaceReqd(totalSpaceRequired) > usableSpace) {
            this.deleteFilesInAdvance(indexDir, indexDirPath, totalSpaceRequired, usableSpace);
        }
        for (Map<String, Object> file : this.filesToDownload) {
            String filename = (String)file.get("name");
            long size = (Long)file.get("size");
            CompareResult compareResult = IndexFetcher.compareFile(indexDir, filename, size, (Long)file.get("checksum"));
            boolean alwaysDownload = IndexFetcher.filesToAlwaysDownloadIfNoChecksums(filename, size, compareResult);
            if (log.isDebugEnabled()) {
                log.debug("Downloading file={} size={} checksum={} alwaysDownload={}", new Object[]{filename, size, file.get("checksum"), alwaysDownload});
            }
            if (!compareResult.equal || downloadCompleteIndex || alwaysDownload) {
                File localFile = new File(indexDirPath, filename);
                if (downloadCompleteIndex && doDifferentialCopy && compareResult.equal && compareResult.checkSummed && localFile.exists()) {
                    if (log.isInfoEnabled()) {
                        log.info("Don't need to download this file. Local file's path is: {}, checksum is: {}", (Object)localFile.getAbsolutePath(), file.get("checksum"));
                    }
                    Files.createLink(new File(tmpIndexDirPath, filename).toPath(), localFile.toPath());
                    bytesSkippedCopying += localFile.length();
                } else {
                    this.dirFileFetcher = new DirectoryFileFetcher(tmpIndexDir, file, (String)file.get("name"), "file", latestGeneration);
                    this.currentFile = file;
                    this.dirFileFetcher.fetchFile();
                    bytesDownloaded += this.dirFileFetcher.getBytesDownloaded();
                }
                this.filesDownloaded.add(new HashMap<String, Object>(file));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Skipping download for {} because it already exists", file.get("name"));
        }
        log.info("Bytes downloaded: {}, Bytes skipped downloading: {}", (Object)bytesDownloaded, (Object)bytesSkippedCopying);
        return bytesDownloaded;
    }

    private static Long getUsableSpace(String dir) {
        try {
            File file = new File(dir);
            if (!file.exists() && !(file = file.getParentFile()).exists()) {
                return Long.MAX_VALUE;
            }
            FileStore fileStore = Files.getFileStore(file.toPath());
            return fileStore.getUsableSpace();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not free disk space", (Throwable)e);
        }
    }

    private long getApproxTotalSpaceReqd(long totalSpaceRequired) {
        long approxTotalSpaceReqd = (long)((double)totalSpaceRequired * 1.05);
        return approxTotalSpaceReqd += 0x6400000L;
    }

    private void deleteFilesInAdvance(Directory indexDir, String indexDirPath, long usableDiskSpace, long totalSpaceRequired) throws IOException {
        long actualSpaceReqd = totalSpaceRequired;
        ArrayList<String> filesTobeDeleted = new ArrayList<String>();
        long clearedSpace = 0L;
        for (String f : indexDir.listAll()) {
            for (Map<String, Object> fileInfo : this.filesToDownload) {
                if (!f.equals(fileInfo.get("name"))) continue;
                String filename = (String)fileInfo.get("name");
                long size = (Long)fileInfo.get("size");
                CompareResult compareResult = IndexFetcher.compareFile(indexDir, filename, size, (Long)fileInfo.get("checksum"));
                if (!compareResult.equal || IndexFetcher.filesToAlwaysDownloadIfNoChecksums(f, size, compareResult)) {
                    filesTobeDeleted.add(f);
                    clearedSpace += size;
                    continue;
                }
                actualSpaceReqd -= size;
            }
        }
        if (usableDiskSpace > this.getApproxTotalSpaceReqd(actualSpaceReqd)) {
            return;
        }
        log.info("This disk does not have enough space to download the index from leader. So cleaning up the local index.  This may lead to loss of data/or node if index replication fails in between");
        this.clearLocalIndexFirst = true;
        this.solrCore.searchEnabled = false;
        this.solrCore.indexEnabled = false;
        this.solrCore.getDirectoryFactory().doneWithDirectory(indexDir);
        this.solrCore.deleteNonSnapshotIndexFiles(indexDirPath);
        this.solrCore.closeSearcher();
        assert (testWait.getAsBoolean());
        this.solrCore.getUpdateHandler().getSolrCoreState().closeIndexWriter(this.solrCore, false);
        for (String f : filesTobeDeleted) {
            try {
                indexDir.deleteFile(f);
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {}
        }
    }

    static boolean filesToAlwaysDownloadIfNoChecksums(String filename, long size, CompareResult compareResult) {
        return !compareResult.checkSummed && (filename.endsWith(".si") || filename.endsWith(".liv") || filename.startsWith("segments_") || size < 100000L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static CompareResult compareFile(Directory indexDir, String filename, Long backupIndexFileLen, Long backupIndexFileChecksum) {
        CompareResult compareResult = new CompareResult();
        try (IndexInput indexInput = indexDir.openInput(filename, IOContext.READONCE);){
            long indexFileLen = indexInput.length();
            long indexFileChecksum = 0L;
            if (backupIndexFileChecksum != null) {
                try {
                    indexFileChecksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
                    compareResult.checkSummed = true;
                }
                catch (Exception e) {
                    log.warn("Could not retrieve checksum from file.", (Throwable)e);
                }
            }
            if (!compareResult.checkSummed) {
                if (indexFileLen == backupIndexFileLen) {
                    compareResult.equal = true;
                    CompareResult compareResult2 = compareResult;
                    return compareResult2;
                }
                log.info("File {} did not match. expected length is {} and actual length is {}", new Object[]{filename, backupIndexFileLen, indexFileLen});
                compareResult.equal = false;
                CompareResult compareResult3 = compareResult;
                return compareResult3;
            }
            if (indexFileLen == backupIndexFileLen && indexFileChecksum == backupIndexFileChecksum) {
                compareResult.equal = true;
                CompareResult compareResult4 = compareResult;
                return compareResult4;
            }
            log.warn("File {} did not match. expected checksum is {} and actual is checksum {}. expected length is {} and actual length is {}", new Object[]{filename, backupIndexFileChecksum, indexFileChecksum, backupIndexFileLen, indexFileLen});
            compareResult.equal = false;
            CompareResult compareResult5 = compareResult;
            return compareResult5;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            compareResult.equal = false;
            return compareResult;
        }
        catch (IOException e) {
            log.error("Could not read file {}. Downloading it again", (Object)filename, (Object)e);
            compareResult.equal = false;
            return compareResult;
        }
    }

    private static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    private boolean isIndexStale(Directory dir) throws IOException {
        for (Map<String, Object> file : this.filesToDownload) {
            String filename = (String)file.get("name");
            Long length = (Long)file.get("size");
            Long checksum = (Long)file.get("checksum");
            if (!IndexFetcher.slowFileExists(dir, filename)) continue;
            if (checksum != null) {
                if (IndexFetcher.compareFile((Directory)dir, (String)filename, (Long)length, (Long)checksum).equal) continue;
                return true;
            }
            if (length.longValue() == dir.fileLength(filename)) continue;
            log.warn("File {} did not match. expected length is {} and actual length is {}", new Object[]{filename, length, dir.fileLength(filename)});
            return true;
        }
        return false;
    }

    private boolean moveAFile(Directory tmpIdxDir, Directory indexDir, String fname) {
        log.debug("Moving file: {}", (Object)fname);
        boolean success = false;
        try {
            if (IndexFetcher.slowFileExists(indexDir, fname)) {
                log.warn("Cannot complete replication attempt because file already exists: {}", (Object)fname);
                return false;
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"could not check if a file exists", (Throwable)e);
            return false;
        }
        try {
            this.solrCore.getDirectoryFactory().move(tmpIdxDir, indexDir, fname, DirectoryFactory.IOCONTEXT_NO_CACHE);
            success = true;
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"Could not move file", (Throwable)e);
        }
        return success;
    }

    private boolean moveIndexFiles(Directory tmpIdxDir, Directory indexDir) {
        if (log.isDebugEnabled()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info("From dir files: {}", Arrays.asList(tmpIdxDir.listAll()));
                    log.info("To dir files: {}", Arrays.asList(indexDir.listAll()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String segmentsFile = null;
        for (Map<String, Object> f : this.filesDownloaded) {
            String fname = (String)f.get("name");
            if (fname.startsWith("segments_")) {
                segmentsFile = fname;
                continue;
            }
            if (this.moveAFile(tmpIdxDir, indexDir, fname)) continue;
            return false;
        }
        return segmentsFile == null || this.moveAFile(tmpIdxDir, indexDir, segmentsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveTlogFiles(File tmpTlogDir) {
        UpdateLog ulog = this.solrCore.getUpdateHandler().getUpdateLog();
        VersionInfo vinfo = ulog.getVersionInfo();
        vinfo.blockUpdates();
        try {
            CdcrUpdateLog.BufferedUpdates bufferedUpdates = ((CdcrUpdateLog)ulog).resetForRecovery();
            if (!this.copyTmpTlogFiles2Tlog(tmpTlogDir)) {
                boolean bl = false;
                return bl;
            }
            if (bufferedUpdates.tlog != null) {
                File parentDir = FileSystems.getDefault().getPath(this.solrCore.getUpdateHandler().getUpdateLog().getLogDir(), new String[0]).getParent().toFile();
                File backupTlogDir = new File(parentDir, tmpTlogDir.getName());
                bufferedUpdates.tlog = new File(backupTlogDir, bufferedUpdates.tlog.getName());
            }
            ((CdcrUpdateLog)ulog).initForRecovery(bufferedUpdates.tlog, bufferedUpdates.offset);
        }
        catch (Exception e) {
            log.error("Unable to copy tlog files", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            vinfo.unblockUpdates();
        }
        return true;
    }

    private List<File> makeTmpConfDirFileList(File dir, List<File> fileList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileList = this.makeTmpConfDirFileList(file, fileList);
        }
        return fileList;
    }

    private void copyTmpConfFiles2Conf(File tmpconfDir) {
        boolean status = false;
        File confDir = new File(this.solrCore.getResourceLoader().getConfigDir());
        for (File file : this.makeTmpConfDirFileList(tmpconfDir, new ArrayList<File>())) {
            File oldFile = new File(confDir, file.getPath().substring(tmpconfDir.getPath().length(), file.getPath().length()));
            if (!oldFile.getParentFile().exists() && !(status = oldFile.getParentFile().mkdirs())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + oldFile.getParentFile());
            }
            if (oldFile.exists()) {
                File backupFile = new File(oldFile.getPath() + "." + this.getDateAsStr(new Date(oldFile.lastModified())));
                if (!backupFile.getParentFile().exists() && !(status = backupFile.getParentFile().mkdirs())) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + backupFile.getParentFile());
                }
                status = oldFile.renameTo(backupFile);
                if (!status) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + oldFile + " to: " + backupFile);
                }
            }
            if (status = file.renameTo(oldFile)) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + file + " to: " + oldFile);
        }
    }

    private boolean copyTmpTlogFiles2Tlog(File tmpTlogDir) {
        Path tlogDir = FileSystems.getDefault().getPath(this.solrCore.getUpdateHandler().getUpdateLog().getLogDir(), new String[0]);
        Path backupTlogDir = FileSystems.getDefault().getPath(tlogDir.getParent().toAbsolutePath().toString(), tmpTlogDir.getName());
        try {
            Files.move(tlogDir, backupTlogDir, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)("Unable to rename: " + tlogDir + " to: " + backupTlogDir), (Throwable)e);
            return false;
        }
        Path src = FileSystems.getDefault().getPath(backupTlogDir.toAbsolutePath().toString(), tmpTlogDir.getName());
        try {
            Files.move(src, tlogDir, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)("Unable to rename: " + src + " to: " + tlogDir), (Throwable)e);
            try {
                Files.move(backupTlogDir, tlogDir, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e2) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + backupTlogDir + " to: " + tlogDir);
            }
            return false;
        }
        return true;
    }

    private String getDateAsStr(Date d) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(d);
    }

    private Collection<Map<String, Object>> getModifiedConfFiles(List<Map<String, Object>> confFilesToDownload) {
        if (confFilesToDownload == null || confFilesToDownload.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Map<String, Object>> nameVsFile = new HashMap<String, Map<String, Object>>();
        NamedList names = new NamedList();
        for (Map<String, Object> map : confFilesToDownload) {
            String name = (String)(map.get("alias") == null ? map.get("name") : map.get("alias"));
            nameVsFile.put(name, map);
            names.add(name, null);
        }
        List<Map<String, Object>> localFilesInfo = this.replicationHandler.getConfFileInfoFromCache((NamedList<String>)names, this.confFileInfoCache);
        for (Map<String, Object> fileInfo : localFilesInfo) {
            String name = (String)fileInfo.get("name");
            Map m = (Map)nameVsFile.get(name);
            if (m == null || !m.get("checksum").equals(fileInfo.get("checksum"))) continue;
            nameVsFile.remove(name);
        }
        return nameVsFile.isEmpty() ? Collections.emptyList() : nameVsFile.values();
    }

    static Throwable delete(File file) {
        try {
            Files.delete(file.toPath());
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable other) {
            return other;
        }
    }

    static boolean delTree(File dir) {
        try {
            IOUtils.rm((Path[])new Path[]{dir.toPath()});
            return true;
        }
        catch (IOException e) {
            log.warn("Unable to delete directory : {}", (Object)dir, (Object)e);
            return false;
        }
    }

    void abortFetch() {
        this.stop = true;
    }

    @SuppressForbidden(reason="Need currentTimeMillis for debugging/stats")
    private void markReplicationStart() {
        this.replicationTimer = new RTimer();
        this.replicationStartTimeStamp = new Date();
    }

    private void markReplicationStop() {
        this.replicationStartTimeStamp = null;
        this.replicationTimer = null;
    }

    Date getReplicationStartTimeStamp() {
        return this.replicationStartTimeStamp;
    }

    long getReplicationTimeElapsed() {
        long timeElapsed = 0L;
        if (this.replicationStartTimeStamp != null) {
            timeElapsed = TimeUnit.SECONDS.convert((long)this.replicationTimer.getTime(), TimeUnit.MILLISECONDS);
        }
        return timeElapsed;
    }

    List<Map<String, Object>> getTlogFilesToDownload() {
        List<Map<String, Object>> tmp = this.tlogFilesToDownload;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getTlogFilesDownloaded() {
        List<Map<String, Object>> tmp = this.tlogFilesDownloaded;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getConfFilesToDownload() {
        List<Map<String, Object>> tmp = this.confFilesToDownload;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getConfFilesDownloaded() {
        List<Map<String, Object>> tmp = this.confFilesDownloaded;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesToDownload() {
        List<Map<String, Object>> tmp = this.filesToDownload;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesDownloaded() {
        List<Map<String, Object>> tmp = this.filesDownloaded;
        return tmp == null ? Collections.emptyList() : new ArrayList<Map<String, Object>>(tmp);
    }

    Map<String, Object> getCurrentFile() {
        Map<String, Object> tmp = this.currentFile;
        DirectoryFileFetcher tmpFileFetcher = this.dirFileFetcher;
        if (tmp == null) {
            return null;
        }
        tmp = new HashMap<String, Object>(tmp);
        if (tmpFileFetcher != null) {
            tmp.put("bytesDownloaded", tmpFileFetcher.getBytesDownloaded());
        }
        return tmp;
    }

    NamedList getDetails() throws IOException, SolrServerException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"details"});
        params.set("follower", false);
        params.set("qt", new String[]{"/replication"});
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.leaderUrl).withHttpClient(this.myHttpClient)).withConnectionTimeout(this.connTimeout.intValue())).withSocketTimeout(this.soTimeout.intValue())).build();){
            QueryRequest request = new QueryRequest((SolrParams)params);
            NamedList namedList = client.request((SolrRequest)request);
            return namedList;
        }
    }

    public void destroy() {
        this.abortFetch();
        HttpClientUtil.close((HttpClient)this.myHttpClient);
    }

    String getLeaderUrl() {
        return this.leaderUrl;
    }

    private class LocalFsFileFetcher
    extends FileFetcher {
        LocalFsFileFetcher(File dir, Map<String, Object> fileDetails, String saveAs, String solrParamOutput, long latestGen) throws IOException {
            super(new LocalFsFile(dir, saveAs), fileDetails, saveAs, solrParamOutput, latestGen);
        }
    }

    private static class LocalFsFile
    implements FileInterface {
        private File copy2Dir;
        FileChannel fileChannel;
        private FileOutputStream fileOutputStream;
        File file;

        LocalFsFile(File dir, String saveAs) throws IOException {
            this.copy2Dir = dir;
            this.file = new File(this.copy2Dir, saveAs);
            File parentDir = this.file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create (sub)directory for file: " + saveAs);
            }
            this.fileOutputStream = new FileOutputStream(this.file);
            this.fileChannel = this.fileOutputStream.getChannel();
        }

        @Override
        public void sync() throws IOException {
            FileUtils.sync(this.file);
        }

        @Override
        public void write(byte[] buf, int packetSize) throws IOException {
            this.fileChannel.write(ByteBuffer.wrap(buf, 0, packetSize));
        }

        @Override
        public void close() throws Exception {
            this.fileOutputStream.close();
        }

        @Override
        public void delete() throws Exception {
            Files.delete(this.file.toPath());
        }
    }

    private class DirectoryFileFetcher
    extends FileFetcher {
        DirectoryFileFetcher(Directory tmpIndexDir, Map<String, Object> fileDetails, String saveAs, String solrParamOutput, long latestGen) throws IOException {
            super(new DirectoryFile(tmpIndexDir, saveAs), fileDetails, saveAs, solrParamOutput, latestGen);
        }
    }

    private static class DirectoryFile
    implements FileInterface {
        private final String saveAs;
        private Directory copy2Dir;
        private IndexOutput outStream;

        DirectoryFile(Directory tmpIndexDir, String saveAs) throws IOException {
            this.saveAs = saveAs;
            this.copy2Dir = tmpIndexDir;
            this.outStream = this.copy2Dir.createOutput(this.saveAs, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }

        @Override
        public void sync() throws IOException {
            this.copy2Dir.sync(Collections.singleton(this.saveAs));
        }

        @Override
        public void write(byte[] buf, int packetSize) throws IOException {
            this.outStream.writeBytes(buf, 0, packetSize);
        }

        @Override
        public void close() throws Exception {
            this.outStream.close();
        }

        @Override
        public void delete() throws Exception {
            this.copy2Dir.deleteFile(this.saveAs);
        }
    }

    private class FileFetcher {
        private final FileInterface file;
        private boolean includeChecksum = true;
        private final String fileName;
        private final String saveAs;
        private final String solrParamOutput;
        private final Long indexGen;
        private final long size;
        private long bytesDownloaded = 0L;
        private byte[] buf;
        private final Checksum checksum;
        private int errorCount = 0;
        private boolean aborted = false;

        FileFetcher(FileInterface file, Map<String, Object> fileDetails, String saveAs, String solrParamOutput, long latestGen) throws IOException {
            this.file = file;
            this.fileName = (String)fileDetails.get("name");
            this.size = (Long)fileDetails.get("size");
            this.buf = new byte[(int)Math.min(this.size, 0x100000L)];
            this.solrParamOutput = solrParamOutput;
            this.saveAs = saveAs;
            this.indexGen = latestGen;
            this.checksum = this.includeChecksum ? new Adler32() : null;
        }

        public long getBytesDownloaded() {
            return this.bytesDownloaded;
        }

        public void fetchFile() throws Exception {
            this.bytesDownloaded = 0L;
            try {
                this.fetch();
            }
            catch (Exception e) {
                if (!this.aborted) {
                    SolrException.log((Logger)log, (String)"Error fetching file, doing one retry...", (Throwable)e);
                    this.fetch();
                }
                throw e;
            }
        }

        private void fetch() throws Exception {
            try {
                while (true) {
                    FastInputStream is = this.getStream();
                    try {
                        int result = this.fetchPackets(is);
                        if (result != 0 && result != 1) continue;
                        return;
                    }
                    finally {
                        org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)is);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.cleanup();
                IndexFetcher.this.fsyncService.submit(() -> {
                    try {
                        this.file.sync();
                    }
                    catch (IOException e) {
                        IndexFetcher.this.fsyncException = e;
                    }
                });
            }
        }

        private int fetchPackets(FastInputStream fis) throws Exception {
            byte[] intbytes = new byte[4];
            byte[] longbytes = new byte[8];
            try {
                do {
                    if (IndexFetcher.this.stop) {
                        IndexFetcher.this.stop = false;
                        this.aborted = true;
                        throw new ReplicationHandlerException("User aborted replication");
                    }
                    long checkSumServer = -1L;
                    fis.readFully(intbytes);
                    int packetSize = this.readInt(intbytes);
                    if (packetSize <= 0) {
                        log.warn("No content received for file: {}", (Object)this.fileName);
                        return 1;
                    }
                    if (this.buf.length < packetSize) {
                        this.buf = new byte[packetSize];
                    }
                    if (this.checksum != null) {
                        fis.readFully(longbytes);
                        checkSumServer = this.readLong(longbytes);
                    }
                    fis.readFully(this.buf, 0, packetSize);
                    if (this.includeChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, packetSize);
                        long checkSumClient = this.checksum.getValue();
                        if (checkSumClient != checkSumServer) {
                            log.error("Checksum not matched between client and server for file: {}", (Object)this.fileName);
                            return 1;
                        }
                    }
                    this.file.write(this.buf, packetSize);
                    this.bytesDownloaded += (long)packetSize;
                    log.debug("Fetched and wrote {} bytes of file: {}", (Object)this.bytesDownloaded, (Object)this.fileName);
                    this.errorCount = 0;
                } while (this.bytesDownloaded < this.size);
                return 0;
            }
            catch (ReplicationHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn("Error in fetching file: {} (downloaded {} of {} bytes)", new Object[]{this.fileName, this.bytesDownloaded, this.size, e});
                ++this.errorCount;
                if (this.errorCount > 5) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to fetch file: " + this.fileName + " (downloaded " + this.bytesDownloaded + " of " + this.size + " bytes, error count: " + this.errorCount + " > " + 5 + ")", (Throwable)e);
                }
                return 2;
            }
        }

        private int readInt(byte[] b) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }

        private long readLong(byte[] b) {
            return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)((b[5] & 0xFF) << 16) | (long)((b[6] & 0xFF) << 8) | (long)(b[7] & 0xFF);
        }

        private void cleanup() {
            try {
                this.file.close();
            }
            catch (Exception e) {
                log.error("Error closing file: {}", (Object)this.saveAs, (Object)e);
            }
            if (this.bytesDownloaded != this.size) {
                try {
                    this.file.delete();
                }
                catch (Exception e) {
                    log.error("Error deleting file: {}", (Object)this.saveAs, (Object)e);
                }
                if (!this.aborted) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to download " + this.fileName + " completely. Downloaded " + this.bytesDownloaded + "!=" + this.size);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private FastInputStream getStream() throws IOException {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("command", new String[]{"filecontent"});
            params.set("generation", new String[]{Long.toString(this.indexGen)});
            params.set("qt", new String[]{"/replication"});
            params.set(this.solrParamOutput, new String[]{this.fileName});
            if (IndexFetcher.this.useInternalCompression) {
                params.set("compression", new String[]{"true"});
            }
            if (this.includeChecksum) {
                params.set("checksum", true);
            }
            params.set("wt", new String[]{"filestream"});
            if (this.bytesDownloaded > 0L) {
                params.set("offset", new String[]{Long.toString(this.bytesDownloaded)});
            }
            InputStream is = null;
            try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(IndexFetcher.this.leaderUrl).withHttpClient(IndexFetcher.this.myHttpClient)).withResponseParser(null)).withConnectionTimeout(IndexFetcher.this.connTimeout.intValue())).withSocketTimeout(IndexFetcher.this.soTimeout.intValue())).build();){
                QueryRequest req = new QueryRequest((SolrParams)params);
                NamedList response = client.request((SolrRequest)req);
                is = (InputStream)response.get("stream");
                if (IndexFetcher.this.useInternalCompression) {
                    is = new InflaterInputStream(is);
                }
                FastInputStream fastInputStream = new FastInputStream(is);
                return fastInputStream;
            }
            catch (Exception e) {
                org.apache.commons.io.IOUtils.closeQuietly(is);
                throw new IOException("Could not download file '" + this.fileName + "'", e);
            }
        }
    }

    private static interface FileInterface {
        public void sync() throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void close() throws Exception;

        public void delete() throws Exception;
    }

    private static class ReplicationHandlerException
    extends InterruptedException {
        public ReplicationHandlerException(String message) {
            super(message);
        }
    }

    protected static class CompareResult {
        boolean equal = false;
        boolean checkSummed = false;

        protected CompareResult() {
        }
    }

    public static class IndexFetchResult {
        private final String message;
        private final boolean successful;
        private final Throwable exception;
        public static final String FAILED_BY_INTERRUPT_MESSAGE = "Fetching index failed by interrupt";
        public static final String FAILED_BY_EXCEPTION_MESSAGE = "Fetching index failed by exception";
        public static final IndexFetchResult ALREADY_IN_SYNC = new IndexFetchResult("Local index commit is already in sync with peer", true, null);
        public static final IndexFetchResult INDEX_FETCH_FAILURE = new IndexFetchResult("Fetching lastest index is failed", false, null);
        public static final IndexFetchResult INDEX_FETCH_SUCCESS = new IndexFetchResult("Fetching latest index is successful", true, null);
        public static final IndexFetchResult LOCK_OBTAIN_FAILED = new IndexFetchResult("Obtaining SnapPuller lock failed", false, null);
        public static final IndexFetchResult CONTAINER_IS_SHUTTING_DOWN = new IndexFetchResult("I was asked to replicate but CoreContainer is shutting down", false, null);
        public static final IndexFetchResult LEADER_VERSION_ZERO = new IndexFetchResult("Index in peer is empty and never committed yet", true, null);
        public static final IndexFetchResult NO_INDEX_COMMIT_EXIST = new IndexFetchResult("No IndexCommit in local index", false, null);
        public static final IndexFetchResult PEER_INDEX_COMMIT_DELETED = new IndexFetchResult("No files to download because IndexCommit in peer was deleted", false, null);
        public static final IndexFetchResult LOCAL_ACTIVITY_DURING_REPLICATION = new IndexFetchResult("Local index modification during replication", false, null);
        public static final IndexFetchResult EXPECTING_NON_LEADER = new IndexFetchResult("Replicating from leader but I'm the shard leader", false, null);
        public static final IndexFetchResult LEADER_IS_NOT_ACTIVE = new IndexFetchResult("Replicating from leader but leader is not active", false, null);

        IndexFetchResult(String message, boolean successful, Throwable exception) {
            this.message = message;
            this.successful = successful;
            this.exception = exception;
        }

        public Throwable getException() {
            return this.exception;
        }

        public boolean getSuccessful() {
            return this.successful;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

