/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.UniformReservoir;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSuppliers {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Clock CPU_CLOCK = new CpuTimeClock();
    private static final Clock USER_CLOCK = new Clock.UserTimeClock();
    public static final String CLOCK = "clock";
    public static final String CLOCK_USER = "user";
    public static final String CLOCK_CPU = "cpu";
    public static final String RESERVOIR = "reservoir";
    public static final String RESERVOIR_SIZE = "size";
    public static final String RESERVOIR_EDR_ALPHA = "alpha";
    public static final String RESERVOIR_WINDOW = "window";
    private static final String EDR_CLAZZ = ExponentiallyDecayingReservoir.class.getName();
    private static final String UNI_CLAZZ = UniformReservoir.class.getName();
    private static final String STW_CLAZZ = SlidingTimeWindowReservoir.class.getName();
    private static final String SW_CLAZZ = SlidingWindowReservoir.class.getName();
    private static final int DEFAULT_SIZE = 1028;
    private static final double DEFAULT_ALPHA = 0.015;
    private static final long DEFAULT_WINDOW = 300L;

    private static Clock getClock(PluginInfo info, String param) {
        if (info == null) {
            return Clock.defaultClock();
        }
        String clock = null;
        if (info.attributes != null) {
            clock = info.attributes.get(param);
        }
        if (clock == null && info.initArgs != null) {
            clock = (String)info.initArgs.get(param);
        }
        Clock clk = Clock.defaultClock();
        if (clock != null) {
            if (clock.equalsIgnoreCase(CLOCK_USER)) {
                clk = USER_CLOCK;
            } else if (clock.equalsIgnoreCase(CLOCK_CPU)) {
                clk = CPU_CLOCK;
            }
        }
        return clk;
    }

    private static final Reservoir getReservoir(SolrResourceLoader loader, PluginInfo info) {
        if (info == null) {
            return new ExponentiallyDecayingReservoir();
        }
        Clock clk = MetricSuppliers.getClock(info, CLOCK);
        String clazz = ExponentiallyDecayingReservoir.class.getName();
        int size = -1;
        double alpha = -1.0;
        long window = -1L;
        if (info.initArgs != null) {
            Number n;
            String val;
            if (info.initArgs.get(RESERVOIR) != null && !(val = String.valueOf(info.initArgs.get(RESERVOIR)).trim()).isEmpty()) {
                clazz = val;
            }
            if ((n = (Number)info.initArgs.get(RESERVOIR_SIZE)) != null) {
                size = n.intValue();
            }
            if ((n = (Number)info.initArgs.get(RESERVOIR_EDR_ALPHA)) != null) {
                alpha = n.doubleValue();
            }
            if ((n = (Number)info.initArgs.get(RESERVOIR_WINDOW)) != null) {
                window = n.longValue();
            }
        }
        if (size <= 0) {
            size = 1028;
        }
        if (alpha <= 0.0) {
            alpha = 0.015;
        }
        if (clazz.equals(EDR_CLAZZ)) {
            return new ExponentiallyDecayingReservoir(size, alpha, clk);
        }
        if (clazz.equals(UNI_CLAZZ)) {
            return new UniformReservoir(size);
        }
        if (clazz.equals(STW_CLAZZ)) {
            if (window <= 0L) {
                window = 300L;
            }
            return new SlidingTimeWindowReservoir(window, TimeUnit.SECONDS);
        }
        if (clazz.equals(SW_CLAZZ)) {
            return new SlidingWindowReservoir(size);
        }
        if (loader == null) {
            return new ExponentiallyDecayingReservoir(size, alpha, clk);
        }
        try {
            Reservoir reservoir = loader.newInstance(clazz, Reservoir.class);
            if (reservoir instanceof PluginInfoInitialized) {
                ((PluginInfoInitialized)reservoir).init(info);
            } else {
                SolrPluginUtils.invokeSetters(reservoir, (Iterable<Map.Entry<String, Object>>)info.initArgs, true);
            }
            return reservoir;
        }
        catch (Exception e) {
            log.warn("Error initializing custom Reservoir implementation (will use default): {}", (Object)info, (Object)e);
            return new ExponentiallyDecayingReservoir(size, alpha, clk);
        }
    }

    public static MetricRegistry.MetricSupplier<Counter> counterSupplier(SolrResourceLoader loader, PluginInfo info) {
        DefaultCounterSupplier supplier;
        if (info == null || info.className == null || info.className.trim().isEmpty()) {
            return new DefaultCounterSupplier();
        }
        if ("__noop__".equals(info.className)) {
            return NoOpCounterSupplier.INSTANCE;
        }
        if (loader == null) {
            supplier = new DefaultCounterSupplier();
        } else {
            try {
                supplier = loader.newInstance(info.className, MetricRegistry.MetricSupplier.class);
            }
            catch (Exception e) {
                log.warn("Error creating custom Counter supplier (will use default): {}", (Object)info, (Object)e);
                supplier = new DefaultCounterSupplier();
            }
        }
        if (supplier instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)((Object)supplier)).init(info);
        } else {
            SolrPluginUtils.invokeSetters(supplier, (Iterable<Map.Entry<String, Object>>)info.initArgs, true);
        }
        return supplier;
    }

    public static MetricRegistry.MetricSupplier<Meter> meterSupplier(SolrResourceLoader loader, PluginInfo info) {
        DefaultMeterSupplier supplier;
        if (info == null || info.className == null || info.className.isEmpty()) {
            supplier = new DefaultMeterSupplier();
        } else {
            if ("__noop__".equals(info.className)) {
                return NoOpMeterSupplier.INSTANCE;
            }
            if (loader == null) {
                supplier = new DefaultMeterSupplier();
            } else {
                try {
                    supplier = loader.newInstance(info.className, MetricRegistry.MetricSupplier.class);
                }
                catch (Exception e) {
                    log.warn("Error creating custom Meter supplier (will use default): {}", (Object)info, (Object)e);
                    supplier = new DefaultMeterSupplier();
                }
            }
        }
        if (supplier instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)supplier).init(info);
        } else {
            SolrPluginUtils.invokeSetters(supplier, (Iterable<Map.Entry<String, Object>>)info.initArgs, true);
        }
        return supplier;
    }

    public static MetricRegistry.MetricSupplier<Timer> timerSupplier(SolrResourceLoader loader, PluginInfo info) {
        DefaultTimerSupplier supplier;
        if (info == null || info.className == null || info.className.isEmpty()) {
            supplier = new DefaultTimerSupplier(loader);
        } else {
            if ("__noop__".equals(info.className)) {
                return NoOpTimerSupplier.INSTANCE;
            }
            if (loader == null) {
                supplier = new DefaultTimerSupplier(null);
            } else {
                try {
                    supplier = loader.newInstance(info.className, MetricRegistry.MetricSupplier.class);
                }
                catch (Exception e) {
                    log.warn("Error creating custom Timer supplier (will use default): {}", (Object)info, (Object)e);
                    supplier = new DefaultTimerSupplier(loader);
                }
            }
        }
        if (supplier instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)supplier).init(info);
        } else {
            SolrPluginUtils.invokeSetters(supplier, (Iterable<Map.Entry<String, Object>>)info.initArgs, true);
        }
        return supplier;
    }

    public static MetricRegistry.MetricSupplier<Histogram> histogramSupplier(SolrResourceLoader loader, PluginInfo info) {
        DefaultHistogramSupplier supplier;
        if (info == null || info.className == null || info.className.isEmpty()) {
            supplier = new DefaultHistogramSupplier(loader);
        } else {
            if ("__noop__".equals(info.className)) {
                return NoOpHistogramSupplier.INSTANCE;
            }
            if (loader == null) {
                supplier = new DefaultHistogramSupplier(null);
            } else {
                try {
                    supplier = loader.newInstance(info.className, MetricRegistry.MetricSupplier.class);
                }
                catch (Exception e) {
                    log.warn("Error creating custom Histogram supplier (will use default): {}", (Object)info, (Object)e);
                    supplier = new DefaultHistogramSupplier(loader);
                }
            }
        }
        if (supplier instanceof PluginInfoInitialized) {
            ((PluginInfoInitialized)supplier).init(info);
        } else {
            SolrPluginUtils.invokeSetters(supplier, (Iterable<Map.Entry<String, Object>>)info.initArgs, true);
        }
        return supplier;
    }

    public static <T> Gauge<T> getNoOpGauge(Gauge<T> actual) {
        return NoOpGauge.INSTANCE;
    }

    public static final class NoOpGauge
    implements Gauge<Object>,
    NoOpMetric {
        public static final NoOpGauge INSTANCE = new NoOpGauge();

        public Object getValue() {
            return null;
        }
    }

    public static final class NoOpTimerSupplier
    implements MetricRegistry.MetricSupplier<Timer> {
        public static final NoOpTimerSupplier INSTANCE = new NoOpTimerSupplier();
        private static final NoOpTimer METRIC = new NoOpTimer();

        public Timer newMetric() {
            return METRIC;
        }

        private static final class NoOpTimer
        extends Timer
        implements NoOpMetric {
            private NoOpTimer() {
            }

            public void update(long duration, TimeUnit unit) {
            }

            public void update(Duration duration) {
            }

            public <T> T time(Callable<T> event) throws Exception {
                return event.call();
            }

            public <T> T timeSupplier(Supplier<T> event) {
                return event.get();
            }

            public void time(Runnable event) {
                event.run();
            }
        }
    }

    public static final class NoOpMeterSupplier
    implements MetricRegistry.MetricSupplier<Meter> {
        public static final NoOpMeterSupplier INSTANCE = new NoOpMeterSupplier();
        private static final NoOpMeter METRIC = new NoOpMeter();

        public Meter newMetric() {
            return METRIC;
        }

        private static final class NoOpMeter
        extends Meter
        implements NoOpMetric {
            private NoOpMeter() {
            }

            public void mark() {
            }

            public void mark(long n) {
            }
        }
    }

    public static final class NoOpHistogramSupplier
    implements MetricRegistry.MetricSupplier<Histogram> {
        public static final NoOpHistogramSupplier INSTANCE = new NoOpHistogramSupplier();
        private static final NoOpHistogram METRIC = new NoOpHistogram();

        public Histogram newMetric() {
            return METRIC;
        }

        private static final class NoOpHistogram
        extends Histogram
        implements NoOpMetric {
            public NoOpHistogram() {
                super((Reservoir)new UniformReservoir(1));
            }

            public void update(int value) {
            }

            public void update(long value) {
            }
        }
    }

    public static final class NoOpCounterSupplier
    implements MetricRegistry.MetricSupplier<Counter> {
        public static final NoOpCounterSupplier INSTANCE = new NoOpCounterSupplier();
        private static final Counter METRIC = new NoOpCounter();

        public Counter newMetric() {
            return METRIC;
        }

        private static final class NoOpCounter
        extends Counter
        implements NoOpMetric {
            private NoOpCounter() {
            }

            public void inc() {
            }

            public void inc(long n) {
            }

            public void dec() {
            }

            public void dec(long n) {
            }
        }
    }

    public static interface NoOpMetric {
    }

    public static final class DefaultHistogramSupplier
    implements MetricRegistry.MetricSupplier<Histogram>,
    PluginInfoInitialized {
        private PluginInfo info;
        private SolrResourceLoader loader;

        public DefaultHistogramSupplier(SolrResourceLoader loader) {
            this.loader = loader;
        }

        @Override
        public void init(PluginInfo info) {
            this.info = info;
        }

        public Reservoir getReservoir() {
            return MetricSuppliers.getReservoir(this.loader, this.info);
        }

        public Histogram newMetric() {
            return new Histogram(this.getReservoir());
        }
    }

    public static final class DefaultTimerSupplier
    implements MetricRegistry.MetricSupplier<Timer>,
    PluginInfoInitialized {
        public Clock clk = Clock.defaultClock();
        private PluginInfo info;
        private SolrResourceLoader loader;

        public DefaultTimerSupplier(SolrResourceLoader loader) {
            this.loader = loader;
        }

        @Override
        public void init(PluginInfo info) {
            this.clk = MetricSuppliers.getClock(info, MetricSuppliers.CLOCK);
            this.info = info;
        }

        public Reservoir getReservoir() {
            return MetricSuppliers.getReservoir(this.loader, this.info);
        }

        public Timer newMetric() {
            return new Timer(this.getReservoir(), this.clk);
        }
    }

    public static final class DefaultMeterSupplier
    implements MetricRegistry.MetricSupplier<Meter>,
    PluginInfoInitialized {
        public Clock clk = Clock.defaultClock();

        @Override
        public void init(PluginInfo info) {
            this.clk = MetricSuppliers.getClock(info, MetricSuppliers.CLOCK);
        }

        public Meter newMetric() {
            return new Meter(this.clk);
        }
    }

    private static final class CpuTimeClock
    extends Clock {
        private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

        private CpuTimeClock() {
        }

        public long getTick() {
            return THREAD_MX_BEAN.getCurrentThreadCpuTime();
        }
    }

    public static final class DefaultCounterSupplier
    implements MetricRegistry.MetricSupplier<Counter> {
        public Counter newMetric() {
            return new Counter();
        }
    }
}

