/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Rescorer;
import org.apache.lucene.search.Weight;

public class ReRankWeight
extends FilterWeight {
    private final IndexSearcher searcher;
    private final Rescorer reRankQueryRescorer;

    public ReRankWeight(Query mainQuery, Rescorer reRankQueryRescorer, IndexSearcher searcher, Weight mainWeight) throws IOException {
        super(mainQuery, mainWeight);
        this.searcher = searcher;
        this.reRankQueryRescorer = reRankQueryRescorer;
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        Explanation mainExplain = this.in.explain(context, doc);
        return this.reRankQueryRescorer.explain(this.searcher, mainExplain, context.docBase + doc);
    }
}

