/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.util.Arrays;

public class LongPriorityQueue {
    protected int size;
    protected int currentCapacity;
    protected int maxSize;
    protected long[] heap;
    protected final long sentinel;

    public LongPriorityQueue(int initialSize, int maxSize, long sentinel) {
        this.maxSize = maxSize;
        this.sentinel = sentinel;
        this.initialize(initialSize);
    }

    protected void initialize(int sz) {
        int heapSize = 0 == sz ? 2 : Math.max(sz, sz + 1);
        this.heap = new long[heapSize];
        this.currentCapacity = sz;
    }

    public int getCurrentCapacity() {
        return this.currentCapacity;
    }

    public void resize(int sz) {
        if (sz > this.maxSize) {
            this.maxSize = sz;
        }
        int heapSize = 0 == sz ? 2 : Math.max(sz, sz + 1);
        this.heap = Arrays.copyOf(this.heap, heapSize);
        this.currentCapacity = sz;
    }

    public long add(long element) {
        if (this.size >= this.currentCapacity) {
            int newSize = Math.min(this.currentCapacity << 1, this.maxSize);
            if (newSize < this.currentCapacity) {
                newSize = Integer.MAX_VALUE;
            }
            this.resize(newSize);
        }
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
        return this.heap[1];
    }

    public void addNoCheck(long element) {
        ++this.size;
        this.heap[this.size] = element;
        this.upHeap();
    }

    public long insertWithOverflow(long element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return this.sentinel;
        }
        if (element > this.heap[1]) {
            long ret = this.heap[1];
            this.heap[1] = element;
            this.updateTop();
            return ret;
        }
        return element;
    }

    public boolean insert(long element) {
        if (this.size < this.maxSize) {
            this.add(element);
            return false;
        }
        if (element > this.heap[1]) {
            this.heap[1] = element;
            this.updateTop();
            return true;
        }
        return false;
    }

    public long top() {
        return this.heap[1];
    }

    public long pop() {
        long result = this.heap[1];
        this.heap[1] = this.heap[this.size];
        --this.size;
        this.downHeap();
        return result;
    }

    public long updateTop() {
        this.downHeap();
        return this.heap[1];
    }

    public int size() {
        return this.size;
    }

    public long[] getInternalArray() {
        return this.heap;
    }

    public long[] sort(int n) {
        while (--n >= 0) {
            long result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = result;
            --this.size;
            this.downHeap();
        }
        return this.heap;
    }

    public void clear() {
        this.size = 0;
    }

    private void upHeap() {
        int i = this.size;
        long node = this.heap[i];
        for (int j = i >>> 1; j > 0 && node < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    private void downHeap() {
        int i = 1;
        long node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < node) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || this.heap[k] >= this.heap[j]) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

