/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

public abstract class CircuitBreaker {
    public static final String NAME = "circuitbreaker";
    protected final CircuitBreakerConfig config;

    public CircuitBreaker(CircuitBreakerConfig config) {
        this.config = config;
    }

    protected boolean isEnabled() {
        return this.config.isEnabled();
    }

    public abstract boolean isTripped();

    public abstract String getDebugInfo();

    public abstract String getErrorMessage();

    public static class CircuitBreakerConfig {
        private final boolean enabled;
        private final boolean memCBEnabled;
        private final int memCBThreshold;
        private final boolean cpuCBEnabled;
        private final int cpuCBThreshold;

        public CircuitBreakerConfig(boolean enabled, boolean memCBEnabled, int memCBThreshold, boolean cpuCBEnabled, int cpuCBThreshold) {
            this.enabled = enabled;
            this.memCBEnabled = memCBEnabled;
            this.memCBThreshold = memCBThreshold;
            this.cpuCBEnabled = cpuCBEnabled;
            this.cpuCBThreshold = cpuCBThreshold;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean getMemCBEnabled() {
            return this.memCBEnabled;
        }

        public int getMemCBThreshold() {
            return this.memCBThreshold;
        }

        public boolean getCpuCBEnabled() {
            return this.cpuCBEnabled;
        }

        public int getCpuCBThreshold() {
            return this.cpuCBThreshold;
        }
    }
}

